package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AggregateStatus(
    signatureMap: Optional[Map[String, Boolean]] = Optional.Absent,
    status: zio.aws.groundstation.model.AgentStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.AggregateStatus = {
    import AggregateStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.AggregateStatus
      .builder()
      .optionallyWith(
        signatureMap.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.Boolean)
            })
            .asJava
        )
      )(_.signatureMap)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.AggregateStatus.ReadOnly =
    zio.aws.groundstation.model.AggregateStatus.wrap(buildAwsValue())
}
object AggregateStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.AggregateStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.AggregateStatus =
      zio.aws.groundstation.model
        .AggregateStatus(signatureMap.map(value => value), status)
    def signatureMap: Optional[Map[String, Boolean]]
    def status: zio.aws.groundstation.model.AgentStatus
    def getSignatureMap: ZIO[Any, AwsError, Map[String, Boolean]] =
      AwsError.unwrapOptionField("signatureMap", signatureMap)
    def getStatus: ZIO[Any, Nothing, zio.aws.groundstation.model.AgentStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.AggregateStatus
  ) extends zio.aws.groundstation.model.AggregateStatus.ReadOnly {
    override val signatureMap: Optional[Map[String, Boolean]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signatureMap())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: Boolean)
            })
            .toMap
        )
    override val status: zio.aws.groundstation.model.AgentStatus =
      zio.aws.groundstation.model.AgentStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.AggregateStatus
  ): zio.aws.groundstation.model.AggregateStatus.ReadOnly = new Wrapper(impl)
}
