package zio.aws.groundstation.model
import scala.jdk.CollectionConverters._
sealed trait AgentStatus {
  def unwrap: software.amazon.awssdk.services.groundstation.model.AgentStatus
}
object AgentStatus {
  def wrap(
      value: software.amazon.awssdk.services.groundstation.model.AgentStatus
  ): zio.aws.groundstation.model.AgentStatus = value match {
    case software.amazon.awssdk.services.groundstation.model.AgentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.groundstation.model.AgentStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.groundstation.model.AgentStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.groundstation.model.AgentStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.groundstation.model.AgentStatus.INACTIVE =>
      val r = INACTIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.groundstation.model.AgentStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.AgentStatus =
      software.amazon.awssdk.services.groundstation.model.AgentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCESS extends zio.aws.groundstation.model.AgentStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.AgentStatus =
      software.amazon.awssdk.services.groundstation.model.AgentStatus.SUCCESS
  }
  case object FAILED extends zio.aws.groundstation.model.AgentStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.AgentStatus =
      software.amazon.awssdk.services.groundstation.model.AgentStatus.FAILED
  }
  case object ACTIVE extends zio.aws.groundstation.model.AgentStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.AgentStatus =
      software.amazon.awssdk.services.groundstation.model.AgentStatus.ACTIVE
  }
  case object INACTIVE extends zio.aws.groundstation.model.AgentStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.AgentStatus =
      software.amazon.awssdk.services.groundstation.model.AgentStatus.INACTIVE
  }
}
