package zio.aws.groundstation.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.groundstation.model.primitives.{
  Uuid,
  SatelliteArn,
  NoradSatelliteID
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SatelliteListItem(
    groundStations: Optional[Iterable[String]] = Optional.Absent,
    noradSatelliteID: Optional[NoradSatelliteID] = Optional.Absent,
    satelliteArn: Optional[SatelliteArn] = Optional.Absent,
    satelliteId: Optional[Uuid] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.SatelliteListItem = {
    import SatelliteListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.SatelliteListItem
      .builder()
      .optionallyWith(
        groundStations.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.groundStations)
      .optionallyWith(
        noradSatelliteID.map(value => NoradSatelliteID.unwrap(value): Integer)
      )(_.noradSatelliteID)
      .optionallyWith(
        satelliteArn.map(value => SatelliteArn.unwrap(value): java.lang.String)
      )(_.satelliteArn)
      .optionallyWith(
        satelliteId.map(value => Uuid.unwrap(value): java.lang.String)
      )(_.satelliteId)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.SatelliteListItem.ReadOnly =
    zio.aws.groundstation.model.SatelliteListItem.wrap(buildAwsValue())
}
object SatelliteListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.SatelliteListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.SatelliteListItem =
      zio.aws.groundstation.model.SatelliteListItem(
        groundStations.map(value => value),
        noradSatelliteID.map(value => value),
        satelliteArn.map(value => value),
        satelliteId.map(value => value)
      )
    def groundStations: Optional[List[String]]
    def noradSatelliteID: Optional[NoradSatelliteID]
    def satelliteArn: Optional[SatelliteArn]
    def satelliteId: Optional[Uuid]
    def getGroundStations: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("groundStations", groundStations)
    def getNoradSatelliteID: ZIO[Any, AwsError, NoradSatelliteID] =
      AwsError.unwrapOptionField("noradSatelliteID", noradSatelliteID)
    def getSatelliteArn: ZIO[Any, AwsError, SatelliteArn] =
      AwsError.unwrapOptionField("satelliteArn", satelliteArn)
    def getSatelliteId: ZIO[Any, AwsError, Uuid] =
      AwsError.unwrapOptionField("satelliteId", satelliteId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.SatelliteListItem
  ) extends zio.aws.groundstation.model.SatelliteListItem.ReadOnly {
    override val groundStations: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.groundStations())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val noradSatelliteID: Optional[NoradSatelliteID] =
      zio.aws.core.internal
        .optionalFromNullable(impl.noradSatelliteID())
        .map(value =>
          zio.aws.groundstation.model.primitives.NoradSatelliteID(value)
        )
    override val satelliteArn: Optional[SatelliteArn] = zio.aws.core.internal
      .optionalFromNullable(impl.satelliteArn())
      .map(value => zio.aws.groundstation.model.primitives.SatelliteArn(value))
    override val satelliteId: Optional[Uuid] = zio.aws.core.internal
      .optionalFromNullable(impl.satelliteId())
      .map(value => zio.aws.groundstation.model.primitives.Uuid(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.SatelliteListItem
  ): zio.aws.groundstation.model.SatelliteListItem.ReadOnly = new Wrapper(impl)
}
