package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListGroundStationsRequest(
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    satelliteId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest = {
    import ListGroundStationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest
      .builder()
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(satelliteId.map(value => value: java.lang.String))(
        _.satelliteId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.ListGroundStationsRequest.ReadOnly =
    zio.aws.groundstation.model.ListGroundStationsRequest.wrap(buildAwsValue())
}
object ListGroundStationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ListGroundStationsRequest =
      zio.aws.groundstation.model.ListGroundStationsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        satelliteId.map(value => value)
      )
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def satelliteId: Optional[String]
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSatelliteId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("satelliteId", satelliteId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest
  ) extends zio.aws.groundstation.model.ListGroundStationsRequest.ReadOnly {
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val satelliteId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.satelliteId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest
  ): zio.aws.groundstation.model.ListGroundStationsRequest.ReadOnly =
    new Wrapper(impl)
}
