package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GroundStationData(
    groundStationId: Optional[String] = Optional.Absent,
    groundStationName: Optional[String] = Optional.Absent,
    region: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.GroundStationData = {
    import GroundStationData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.GroundStationData
      .builder()
      .optionallyWith(groundStationId.map(value => value: java.lang.String))(
        _.groundStationId
      )
      .optionallyWith(groundStationName.map(value => value: java.lang.String))(
        _.groundStationName
      )
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.GroundStationData.ReadOnly =
    zio.aws.groundstation.model.GroundStationData.wrap(buildAwsValue())
}
object GroundStationData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.GroundStationData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.GroundStationData =
      zio.aws.groundstation.model.GroundStationData(
        groundStationId.map(value => value),
        groundStationName.map(value => value),
        region.map(value => value)
      )
    def groundStationId: Optional[String]
    def groundStationName: Optional[String]
    def region: Optional[String]
    def getGroundStationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groundStationId", groundStationId)
    def getGroundStationName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groundStationName", groundStationName)
    def getRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.GroundStationData
  ) extends zio.aws.groundstation.model.GroundStationData.ReadOnly {
    override val groundStationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groundStationId())
      .map(value => value: String)
    override val groundStationName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groundStationName())
      .map(value => value: String)
    override val region: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.GroundStationData
  ): zio.aws.groundstation.model.GroundStationData.ReadOnly = new Wrapper(impl)
}
