package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetMinuteUsageRequest(month: Integer, year: Integer) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.GetMinuteUsageRequest = {
    import GetMinuteUsageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.GetMinuteUsageRequest
      .builder()
      .month(month: java.lang.Integer)
      .year(year: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.GetMinuteUsageRequest.ReadOnly =
    zio.aws.groundstation.model.GetMinuteUsageRequest.wrap(buildAwsValue())
}
object GetMinuteUsageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.GetMinuteUsageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.GetMinuteUsageRequest =
      zio.aws.groundstation.model.GetMinuteUsageRequest(month, year)
    def month: Integer
    def year: Integer
    def getMonth: ZIO[Any, Nothing, Integer] = ZIO.succeed(month)
    def getYear: ZIO[Any, Nothing, Integer] = ZIO.succeed(year)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.GetMinuteUsageRequest
  ) extends zio.aws.groundstation.model.GetMinuteUsageRequest.ReadOnly {
    override val month: Integer = impl.month(): Integer
    override val year: Integer = impl.year(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.GetMinuteUsageRequest
  ): zio.aws.groundstation.model.GetMinuteUsageRequest.ReadOnly = new Wrapper(
    impl
  )
}
