package zio.aws.groundstation.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.groundstation.model.primitives.{
  SatelliteArn,
  MissionProfileArn,
  Timestamp
}
import scala.jdk.CollectionConverters._
final case class ContactData(
    contactId: Optional[String] = Optional.Absent,
    contactStatus: Optional[zio.aws.groundstation.model.ContactStatus] =
      Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent,
    groundStation: Optional[String] = Optional.Absent,
    maximumElevation: Optional[zio.aws.groundstation.model.Elevation] =
      Optional.Absent,
    missionProfileArn: Optional[MissionProfileArn] = Optional.Absent,
    postPassEndTime: Optional[Timestamp] = Optional.Absent,
    prePassStartTime: Optional[Timestamp] = Optional.Absent,
    region: Optional[String] = Optional.Absent,
    satelliteArn: Optional[SatelliteArn] = Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ContactData = {
    import ContactData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ContactData
      .builder()
      .optionallyWith(contactId.map(value => value: java.lang.String))(
        _.contactId
      )
      .optionallyWith(contactStatus.map(value => value.unwrap))(_.contactStatus)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(groundStation.map(value => value: java.lang.String))(
        _.groundStation
      )
      .optionallyWith(maximumElevation.map(value => value.buildAwsValue()))(
        _.maximumElevation
      )
      .optionallyWith(
        missionProfileArn.map(value =>
          MissionProfileArn.unwrap(value): java.lang.String
        )
      )(_.missionProfileArn)
      .optionallyWith(
        postPassEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.postPassEndTime)
      .optionallyWith(
        prePassStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.prePassStartTime)
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(
        satelliteArn.map(value => SatelliteArn.unwrap(value): java.lang.String)
      )(_.satelliteArn)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.ContactData.ReadOnly =
    zio.aws.groundstation.model.ContactData.wrap(buildAwsValue())
}
object ContactData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ContactData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ContactData =
      zio.aws.groundstation.model.ContactData(
        contactId.map(value => value),
        contactStatus.map(value => value),
        endTime.map(value => value),
        errorMessage.map(value => value),
        groundStation.map(value => value),
        maximumElevation.map(value => value.asEditable),
        missionProfileArn.map(value => value),
        postPassEndTime.map(value => value),
        prePassStartTime.map(value => value),
        region.map(value => value),
        satelliteArn.map(value => value),
        startTime.map(value => value),
        tags.map(value => value)
      )
    def contactId: Optional[String]
    def contactStatus: Optional[zio.aws.groundstation.model.ContactStatus]
    def endTime: Optional[Timestamp]
    def errorMessage: Optional[String]
    def groundStation: Optional[String]
    def maximumElevation
        : Optional[zio.aws.groundstation.model.Elevation.ReadOnly]
    def missionProfileArn: Optional[MissionProfileArn]
    def postPassEndTime: Optional[Timestamp]
    def prePassStartTime: Optional[Timestamp]
    def region: Optional[String]
    def satelliteArn: Optional[SatelliteArn]
    def startTime: Optional[Timestamp]
    def tags: Optional[Map[String, String]]
    def getContactId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("contactId", contactId)
    def getContactStatus
        : ZIO[Any, AwsError, zio.aws.groundstation.model.ContactStatus] =
      AwsError.unwrapOptionField("contactStatus", contactStatus)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getGroundStation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groundStation", groundStation)
    def getMaximumElevation
        : ZIO[Any, AwsError, zio.aws.groundstation.model.Elevation.ReadOnly] =
      AwsError.unwrapOptionField("maximumElevation", maximumElevation)
    def getMissionProfileArn: ZIO[Any, AwsError, MissionProfileArn] =
      AwsError.unwrapOptionField("missionProfileArn", missionProfileArn)
    def getPostPassEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("postPassEndTime", postPassEndTime)
    def getPrePassStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("prePassStartTime", prePassStartTime)
    def getRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("region", region)
    def getSatelliteArn: ZIO[Any, AwsError, SatelliteArn] =
      AwsError.unwrapOptionField("satelliteArn", satelliteArn)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ContactData
  ) extends zio.aws.groundstation.model.ContactData.ReadOnly {
    override val contactId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.contactId())
      .map(value => value: String)
    override val contactStatus
        : Optional[zio.aws.groundstation.model.ContactStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactStatus())
        .map(value => zio.aws.groundstation.model.ContactStatus.wrap(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.groundstation.model.primitives.Timestamp(value))
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
    override val groundStation: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groundStation())
      .map(value => value: String)
    override val maximumElevation
        : Optional[zio.aws.groundstation.model.Elevation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumElevation())
        .map(value => zio.aws.groundstation.model.Elevation.wrap(value))
    override val missionProfileArn: Optional[MissionProfileArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.missionProfileArn())
        .map(value =>
          zio.aws.groundstation.model.primitives.MissionProfileArn(value)
        )
    override val postPassEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.postPassEndTime())
      .map(value => zio.aws.groundstation.model.primitives.Timestamp(value))
    override val prePassStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.prePassStartTime())
      .map(value => zio.aws.groundstation.model.primitives.Timestamp(value))
    override val region: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => value: String)
    override val satelliteArn: Optional[SatelliteArn] = zio.aws.core.internal
      .optionalFromNullable(impl.satelliteArn())
      .map(value => zio.aws.groundstation.model.primitives.SatelliteArn(value))
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.groundstation.model.primitives.Timestamp(value))
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ContactData
  ): zio.aws.groundstation.model.ContactData.ReadOnly = new Wrapper(impl)
}
