package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AntennaDownlinkDemodDecodeConfig(
    decodeConfig: zio.aws.groundstation.model.DecodeConfig,
    demodulationConfig: zio.aws.groundstation.model.DemodulationConfig,
    spectrumConfig: zio.aws.groundstation.model.SpectrumConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.AntennaDownlinkDemodDecodeConfig = {
    import AntennaDownlinkDemodDecodeConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.AntennaDownlinkDemodDecodeConfig
      .builder()
      .decodeConfig(decodeConfig.buildAwsValue())
      .demodulationConfig(demodulationConfig.buildAwsValue())
      .spectrumConfig(spectrumConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.AntennaDownlinkDemodDecodeConfig.ReadOnly =
    zio.aws.groundstation.model.AntennaDownlinkDemodDecodeConfig
      .wrap(buildAwsValue())
}
object AntennaDownlinkDemodDecodeConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.AntennaDownlinkDemodDecodeConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.groundstation.model.AntennaDownlinkDemodDecodeConfig =
      zio.aws.groundstation.model.AntennaDownlinkDemodDecodeConfig(
        decodeConfig.asEditable,
        demodulationConfig.asEditable,
        spectrumConfig.asEditable
      )
    def decodeConfig: zio.aws.groundstation.model.DecodeConfig.ReadOnly
    def demodulationConfig
        : zio.aws.groundstation.model.DemodulationConfig.ReadOnly
    def spectrumConfig: zio.aws.groundstation.model.SpectrumConfig.ReadOnly
    def getDecodeConfig
        : ZIO[Any, Nothing, zio.aws.groundstation.model.DecodeConfig.ReadOnly] =
      ZIO.succeed(decodeConfig)
    def getDemodulationConfig: ZIO[
      Any,
      Nothing,
      zio.aws.groundstation.model.DemodulationConfig.ReadOnly
    ] = ZIO.succeed(demodulationConfig)
    def getSpectrumConfig: ZIO[
      Any,
      Nothing,
      zio.aws.groundstation.model.SpectrumConfig.ReadOnly
    ] = ZIO.succeed(spectrumConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.AntennaDownlinkDemodDecodeConfig
  ) extends zio.aws.groundstation.model.AntennaDownlinkDemodDecodeConfig.ReadOnly {
    override val decodeConfig
        : zio.aws.groundstation.model.DecodeConfig.ReadOnly =
      zio.aws.groundstation.model.DecodeConfig.wrap(impl.decodeConfig())
    override val demodulationConfig
        : zio.aws.groundstation.model.DemodulationConfig.ReadOnly =
      zio.aws.groundstation.model.DemodulationConfig
        .wrap(impl.demodulationConfig())
    override val spectrumConfig
        : zio.aws.groundstation.model.SpectrumConfig.ReadOnly =
      zio.aws.groundstation.model.SpectrumConfig.wrap(impl.spectrumConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.AntennaDownlinkDemodDecodeConfig
  ): zio.aws.groundstation.model.AntennaDownlinkDemodDecodeConfig.ReadOnly =
    new Wrapper(impl)
}
