package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SocketAddress(name: String, port: Integer) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.SocketAddress = {
    import SocketAddress.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.SocketAddress
      .builder()
      .name(name: java.lang.String)
      .port(port: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.SocketAddress.ReadOnly =
    zio.aws.groundstation.model.SocketAddress.wrap(buildAwsValue())
}
object SocketAddress {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.SocketAddress
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.SocketAddress =
      zio.aws.groundstation.model.SocketAddress(name, port)
    def name: String
    def port: Integer
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getPort: ZIO[Any, Nothing, Integer] = ZIO.succeed(port)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.SocketAddress
  ) extends zio.aws.groundstation.model.SocketAddress.ReadOnly {
    override val name: String = impl.name(): String
    override val port: Integer = impl.port(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.SocketAddress
  ): zio.aws.groundstation.model.SocketAddress.ReadOnly = new Wrapper(impl)
}
