package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSatellitesResponse(
    nextToken: Optional[String] = Optional.Absent,
    satellites: Optional[
      Iterable[zio.aws.groundstation.model.SatelliteListItem]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ListSatellitesResponse = {
    import ListSatellitesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ListSatellitesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        satellites.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.satellites)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.ListSatellitesResponse.ReadOnly =
    zio.aws.groundstation.model.ListSatellitesResponse.wrap(buildAwsValue())
}
object ListSatellitesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ListSatellitesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ListSatellitesResponse =
      zio.aws.groundstation.model.ListSatellitesResponse(
        nextToken.map(value => value),
        satellites.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def satellites
        : Optional[List[zio.aws.groundstation.model.SatelliteListItem.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSatellites: ZIO[Any, AwsError, List[
      zio.aws.groundstation.model.SatelliteListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("satellites", satellites)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ListSatellitesResponse
  ) extends zio.aws.groundstation.model.ListSatellitesResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val satellites: Optional[
      List[zio.aws.groundstation.model.SatelliteListItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.satellites())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.groundstation.model.SatelliteListItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ListSatellitesResponse
  ): zio.aws.groundstation.model.ListSatellitesResponse.ReadOnly = new Wrapper(
    impl
  )
}
