package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeContactRequest(contactId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.DescribeContactRequest = {
    import DescribeContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.DescribeContactRequest
      .builder()
      .contactId(contactId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.DescribeContactRequest.ReadOnly =
    zio.aws.groundstation.model.DescribeContactRequest.wrap(buildAwsValue())
}
object DescribeContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.DescribeContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.DescribeContactRequest =
      zio.aws.groundstation.model.DescribeContactRequest(contactId)
    def contactId: String
    def getContactId: ZIO[Any, Nothing, String] = ZIO.succeed(contactId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.DescribeContactRequest
  ) extends zio.aws.groundstation.model.DescribeContactRequest.ReadOnly {
    override val contactId: String = impl.contactId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.DescribeContactRequest
  ): zio.aws.groundstation.model.DescribeContactRequest.ReadOnly = new Wrapper(
    impl
  )
}
