package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteMissionProfileRequest(missionProfileId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.DeleteMissionProfileRequest = {
    import DeleteMissionProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.DeleteMissionProfileRequest
      .builder()
      .missionProfileId(missionProfileId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.DeleteMissionProfileRequest.ReadOnly =
    zio.aws.groundstation.model.DeleteMissionProfileRequest
      .wrap(buildAwsValue())
}
object DeleteMissionProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.DeleteMissionProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.DeleteMissionProfileRequest =
      zio.aws.groundstation.model.DeleteMissionProfileRequest(missionProfileId)
    def missionProfileId: String
    def getMissionProfileId: ZIO[Any, Nothing, String] =
      ZIO.succeed(missionProfileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.DeleteMissionProfileRequest
  ) extends zio.aws.groundstation.model.DeleteMissionProfileRequest.ReadOnly {
    override val missionProfileId: String = impl.missionProfileId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.DeleteMissionProfileRequest
  ): zio.aws.groundstation.model.DeleteMissionProfileRequest.ReadOnly =
    new Wrapper(impl)
}
