package zio.aws.groundstation.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.groundstation.model.primitives.{
  SafeName,
  DataflowEndpointMtuInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DataflowEndpoint(
    address: Optional[zio.aws.groundstation.model.SocketAddress] =
      Optional.Absent,
    mtu: Optional[DataflowEndpointMtuInteger] = Optional.Absent,
    name: Optional[SafeName] = Optional.Absent,
    status: Optional[zio.aws.groundstation.model.EndpointStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.DataflowEndpoint = {
    import DataflowEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.DataflowEndpoint
      .builder()
      .optionallyWith(address.map(value => value.buildAwsValue()))(_.address)
      .optionallyWith(
        mtu.map(value => DataflowEndpointMtuInteger.unwrap(value): Integer)
      )(_.mtu)
      .optionallyWith(
        name.map(value => SafeName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.DataflowEndpoint.ReadOnly =
    zio.aws.groundstation.model.DataflowEndpoint.wrap(buildAwsValue())
}
object DataflowEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.DataflowEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.DataflowEndpoint =
      zio.aws.groundstation.model.DataflowEndpoint(
        address.map(value => value.asEditable),
        mtu.map(value => value),
        name.map(value => value),
        status.map(value => value)
      )
    def address: Optional[zio.aws.groundstation.model.SocketAddress.ReadOnly]
    def mtu: Optional[DataflowEndpointMtuInteger]
    def name: Optional[SafeName]
    def status: Optional[zio.aws.groundstation.model.EndpointStatus]
    def getAddress: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.SocketAddress.ReadOnly
    ] = AwsError.unwrapOptionField("address", address)
    def getMtu: ZIO[Any, AwsError, DataflowEndpointMtuInteger] =
      AwsError.unwrapOptionField("mtu", mtu)
    def getName: ZIO[Any, AwsError, SafeName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.groundstation.model.EndpointStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.DataflowEndpoint
  ) extends zio.aws.groundstation.model.DataflowEndpoint.ReadOnly {
    override val address
        : Optional[zio.aws.groundstation.model.SocketAddress.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.address())
        .map(value => zio.aws.groundstation.model.SocketAddress.wrap(value))
    override val mtu: Optional[DataflowEndpointMtuInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mtu())
        .map(value =>
          zio.aws.groundstation.model.primitives
            .DataflowEndpointMtuInteger(value)
        )
    override val name: Optional[SafeName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.groundstation.model.primitives.SafeName(value))
    override val status: Optional[zio.aws.groundstation.model.EndpointStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.groundstation.model.EndpointStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.DataflowEndpoint
  ): zio.aws.groundstation.model.DataflowEndpoint.ReadOnly = new Wrapper(impl)
}
