package zio.aws.groundstation
import zio.aws.groundstation.model.primitives.ConfigArn
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.groundstation.model.primitives.S3KeyPrefix.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object BucketArn extends Subtype[String]
    type BucketArn = zio.aws.groundstation.model.primitives.BucketArn.Type
    object ConfigArn extends Subtype[String]
    type ConfigArn = zio.aws.groundstation.model.primitives.ConfigArn.Type
    object DataflowEndpointGroupArn extends Subtype[String]
    type DataflowEndpointGroupArn =
      zio.aws.groundstation.model.primitives.DataflowEndpointGroupArn.Type
    object DataflowEndpointMtuInteger extends Subtype[Int]
    type DataflowEndpointMtuInteger =
      zio.aws.groundstation.model.primitives.DataflowEndpointMtuInteger.Type
    object DurationInSeconds extends Subtype[Int]
    type DurationInSeconds =
      zio.aws.groundstation.model.primitives.DurationInSeconds.Type
    object Integer extends Subtype[Int]
    type Integer = zio.aws.groundstation.model.primitives.Integer.Type
    object JsonString extends Subtype[String]
    type JsonString = zio.aws.groundstation.model.primitives.JsonString.Type
    object MissionProfileArn extends Subtype[String]
    type MissionProfileArn =
      zio.aws.groundstation.model.primitives.MissionProfileArn.Type
    object NoradSatelliteID extends Subtype[Int]
    type NoradSatelliteID =
      zio.aws.groundstation.model.primitives.NoradSatelliteID.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.groundstation.model.primitives.RoleArn.Type
    object S3KeyPrefix extends Subtype[String]
    type S3KeyPrefix = zio.aws.groundstation.model.primitives.S3KeyPrefix.Type
    object SafeName extends Subtype[String]
    type SafeName = zio.aws.groundstation.model.primitives.SafeName.Type
    object SatelliteArn extends Subtype[String]
    type SatelliteArn = zio.aws.groundstation.model.primitives.SatelliteArn.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.groundstation.model.primitives.Timestamp.Type
    object Uuid extends Subtype[String]
    type Uuid = zio.aws.groundstation.model.primitives.Uuid.Type
  }
  type ConfigList = List[zio.aws.groundstation.model.ConfigListItem]
  type ContactList = List[zio.aws.groundstation.model.ContactData]
  type DataflowEdge = List[ConfigArn]
  type DataflowEdgeList = List[Iterable[ConfigArn]]
  type DataflowEndpointGroupList =
    List[zio.aws.groundstation.model.DataflowEndpointListItem]
  type DataflowList = List[zio.aws.groundstation.model.DataflowDetail]
  type EndpointDetailsList = List[zio.aws.groundstation.model.EndpointDetails]
  type GroundStationIdList = List[String]
  type GroundStationList = List[zio.aws.groundstation.model.GroundStationData]
  type MissionProfileList =
    List[zio.aws.groundstation.model.MissionProfileListItem]
  type SatelliteList = List[zio.aws.groundstation.model.SatelliteListItem]
  type SecurityGroupIdList = List[String]
  type StatusList = List[zio.aws.groundstation.model.ContactStatus]
  type SubnetList = List[String]
  type TagKeys = List[String]
  type TagsMap = Map[String, String]
}
