package zio.aws.groundstation.model
import java.lang.Integer
import zio.aws.groundstation.model.primitives.{
  SafeName,
  ConfigArn,
  DurationInSeconds
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateMissionProfileRequest(
    contactPostPassDurationSeconds: Option[DurationInSeconds] = None,
    contactPrePassDurationSeconds: Option[DurationInSeconds] = None,
    dataflowEdges: Option[Iterable[Iterable[ConfigArn]]] = None,
    minimumViableContactDurationSeconds: Option[DurationInSeconds] = None,
    missionProfileId: String,
    name: Option[SafeName] = None,
    trackingConfigArn: Option[ConfigArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.UpdateMissionProfileRequest = {
    import UpdateMissionProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.UpdateMissionProfileRequest
      .builder()
      .optionallyWith(
        contactPostPassDurationSeconds.map(value =>
          DurationInSeconds.unwrap(value): Integer
        )
      )(_.contactPostPassDurationSeconds)
      .optionallyWith(
        contactPrePassDurationSeconds.map(value =>
          DurationInSeconds.unwrap(value): Integer
        )
      )(_.contactPrePassDurationSeconds)
      .optionallyWith(
        dataflowEdges.map(value =>
          value.map { item =>
            item.map { item =>
              ConfigArn.unwrap(item): java.lang.String
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.dataflowEdges)
      .optionallyWith(
        minimumViableContactDurationSeconds.map(value =>
          DurationInSeconds.unwrap(value): Integer
        )
      )(_.minimumViableContactDurationSeconds)
      .missionProfileId(missionProfileId: java.lang.String)
      .optionallyWith(
        name.map(value => SafeName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        trackingConfigArn.map(value =>
          ConfigArn.unwrap(value): java.lang.String
        )
      )(_.trackingConfigArn)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.UpdateMissionProfileRequest.ReadOnly =
    zio.aws.groundstation.model.UpdateMissionProfileRequest
      .wrap(buildAwsValue())
}
object UpdateMissionProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.UpdateMissionProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.UpdateMissionProfileRequest =
      zio.aws.groundstation.model.UpdateMissionProfileRequest(
        contactPostPassDurationSeconds.map(value => value),
        contactPrePassDurationSeconds.map(value => value),
        dataflowEdges.map(value => value),
        minimumViableContactDurationSeconds.map(value => value),
        missionProfileId,
        name.map(value => value),
        trackingConfigArn.map(value => value)
      )
    def contactPostPassDurationSeconds: Option[DurationInSeconds]
    def contactPrePassDurationSeconds: Option[DurationInSeconds]
    def dataflowEdges: Option[List[List[ConfigArn]]]
    def minimumViableContactDurationSeconds: Option[DurationInSeconds]
    def missionProfileId: String
    def name: Option[SafeName]
    def trackingConfigArn: Option[ConfigArn]
    def getContactPostPassDurationSeconds
        : ZIO[Any, AwsError, DurationInSeconds] = AwsError.unwrapOptionField(
      "contactPostPassDurationSeconds",
      contactPostPassDurationSeconds
    )
    def getContactPrePassDurationSeconds
        : ZIO[Any, AwsError, DurationInSeconds] = AwsError.unwrapOptionField(
      "contactPrePassDurationSeconds",
      contactPrePassDurationSeconds
    )
    def getDataflowEdges: ZIO[Any, AwsError, List[List[ConfigArn]]] =
      AwsError.unwrapOptionField("dataflowEdges", dataflowEdges)
    def getMinimumViableContactDurationSeconds
        : ZIO[Any, AwsError, DurationInSeconds] = AwsError.unwrapOptionField(
      "minimumViableContactDurationSeconds",
      minimumViableContactDurationSeconds
    )
    def getMissionProfileId: ZIO[Any, Nothing, String] =
      ZIO.succeed(missionProfileId)
    def getName: ZIO[Any, AwsError, SafeName] =
      AwsError.unwrapOptionField("name", name)
    def getTrackingConfigArn: ZIO[Any, AwsError, ConfigArn] =
      AwsError.unwrapOptionField("trackingConfigArn", trackingConfigArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.UpdateMissionProfileRequest
  ) extends zio.aws.groundstation.model.UpdateMissionProfileRequest.ReadOnly {
    override val contactPostPassDurationSeconds: Option[DurationInSeconds] =
      scala
        .Option(impl.contactPostPassDurationSeconds())
        .map(value =>
          zio.aws.groundstation.model.primitives.DurationInSeconds(value)
        )
    override val contactPrePassDurationSeconds: Option[DurationInSeconds] =
      scala
        .Option(impl.contactPrePassDurationSeconds())
        .map(value =>
          zio.aws.groundstation.model.primitives.DurationInSeconds(value)
        )
    override val dataflowEdges: Option[List[List[ConfigArn]]] = scala
      .Option(impl.dataflowEdges())
      .map(value =>
        value.asScala.map { item =>
          item.asScala.map { item =>
            zio.aws.groundstation.model.primitives.ConfigArn(item)
          }.toList
        }.toList
      )
    override val minimumViableContactDurationSeconds
        : Option[DurationInSeconds] = scala
      .Option(impl.minimumViableContactDurationSeconds())
      .map(value =>
        zio.aws.groundstation.model.primitives.DurationInSeconds(value)
      )
    override val missionProfileId: String = impl.missionProfileId(): String
    override val name: Option[SafeName] = scala
      .Option(impl.name())
      .map(value => zio.aws.groundstation.model.primitives.SafeName(value))
    override val trackingConfigArn: Option[ConfigArn] = scala
      .Option(impl.trackingConfigArn())
      .map(value => zio.aws.groundstation.model.primitives.ConfigArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.UpdateMissionProfileRequest
  ): zio.aws.groundstation.model.UpdateMissionProfileRequest.ReadOnly =
    new Wrapper(impl)
}
