package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.BucketArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class S3RecordingDetails(
    bucketArn: Option[BucketArn] = None,
    keyTemplate: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.S3RecordingDetails = {
    import S3RecordingDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.S3RecordingDetails
      .builder()
      .optionallyWith(
        bucketArn.map(value => BucketArn.unwrap(value): java.lang.String)
      )(_.bucketArn)
      .optionallyWith(keyTemplate.map(value => value: java.lang.String))(
        _.keyTemplate
      )
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.S3RecordingDetails.ReadOnly =
    zio.aws.groundstation.model.S3RecordingDetails.wrap(buildAwsValue())
}
object S3RecordingDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.S3RecordingDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.S3RecordingDetails =
      zio.aws.groundstation.model.S3RecordingDetails(
        bucketArn.map(value => value),
        keyTemplate.map(value => value)
      )
    def bucketArn: Option[BucketArn]
    def keyTemplate: Option[String]
    def getBucketArn: ZIO[Any, AwsError, BucketArn] =
      AwsError.unwrapOptionField("bucketArn", bucketArn)
    def getKeyTemplate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyTemplate", keyTemplate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.S3RecordingDetails
  ) extends zio.aws.groundstation.model.S3RecordingDetails.ReadOnly {
    override val bucketArn: Option[BucketArn] = scala
      .Option(impl.bucketArn())
      .map(value => zio.aws.groundstation.model.primitives.BucketArn(value))
    override val keyTemplate: Option[String] =
      scala.Option(impl.keyTemplate()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.S3RecordingDetails
  ): zio.aws.groundstation.model.S3RecordingDetails.ReadOnly = new Wrapper(impl)
}
