package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReserveContactResponse(contactId: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ReserveContactResponse = {
    import ReserveContactResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ReserveContactResponse
      .builder()
      .optionallyWith(contactId.map(value => value: java.lang.String))(
        _.contactId
      )
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.ReserveContactResponse.ReadOnly =
    zio.aws.groundstation.model.ReserveContactResponse.wrap(buildAwsValue())
}
object ReserveContactResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ReserveContactResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ReserveContactResponse =
      zio.aws.groundstation.model
        .ReserveContactResponse(contactId.map(value => value))
    def contactId: Option[String]
    def getContactId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("contactId", contactId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ReserveContactResponse
  ) extends zio.aws.groundstation.model.ReserveContactResponse.ReadOnly {
    override val contactId: Option[String] =
      scala.Option(impl.contactId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ReserveContactResponse
  ): zio.aws.groundstation.model.ReserveContactResponse.ReadOnly = new Wrapper(
    impl
  )
}
