package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListContactsResponse(
    contactList: Option[Iterable[zio.aws.groundstation.model.ContactData]] =
      None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ListContactsResponse = {
    import ListContactsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ListContactsResponse
      .builder()
      .optionallyWith(
        contactList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contactList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.ListContactsResponse.ReadOnly =
    zio.aws.groundstation.model.ListContactsResponse.wrap(buildAwsValue())
}
object ListContactsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ListContactsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ListContactsResponse =
      zio.aws.groundstation.model.ListContactsResponse(
        contactList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def contactList
        : Option[List[zio.aws.groundstation.model.ContactData.ReadOnly]]
    def nextToken: Option[String]
    def getContactList: ZIO[Any, AwsError, List[
      zio.aws.groundstation.model.ContactData.ReadOnly
    ]] = AwsError.unwrapOptionField("contactList", contactList)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ListContactsResponse
  ) extends zio.aws.groundstation.model.ListContactsResponse.ReadOnly {
    override val contactList
        : Option[List[zio.aws.groundstation.model.ContactData.ReadOnly]] = scala
      .Option(impl.contactList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.groundstation.model.ContactData.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ListContactsResponse
  ): zio.aws.groundstation.model.ListContactsResponse.ReadOnly = new Wrapper(
    impl
  )
}
