package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListConfigsResponse(
    configList: Option[Iterable[zio.aws.groundstation.model.ConfigListItem]] =
      None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ListConfigsResponse = {
    import ListConfigsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ListConfigsResponse
      .builder()
      .optionallyWith(
        configList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.ListConfigsResponse.ReadOnly =
    zio.aws.groundstation.model.ListConfigsResponse.wrap(buildAwsValue())
}
object ListConfigsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ListConfigsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ListConfigsResponse =
      zio.aws.groundstation.model.ListConfigsResponse(
        configList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def configList
        : Option[List[zio.aws.groundstation.model.ConfigListItem.ReadOnly]]
    def nextToken: Option[String]
    def getConfigList: ZIO[Any, AwsError, List[
      zio.aws.groundstation.model.ConfigListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("configList", configList)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ListConfigsResponse
  ) extends zio.aws.groundstation.model.ListConfigsResponse.ReadOnly {
    override val configList
        : Option[List[zio.aws.groundstation.model.ConfigListItem.ReadOnly]] =
      scala
        .Option(impl.configList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.groundstation.model.ConfigListItem.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ListConfigsResponse
  ): zio.aws.groundstation.model.ListConfigsResponse.ReadOnly = new Wrapper(
    impl
  )
}
