package zio.aws.groundstation.model
import java.lang.Integer
import zio.aws.groundstation.model.primitives.{
  Uuid,
  SatelliteArn,
  NoradSatelliteID
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetSatelliteResponse(
    groundStations: Option[Iterable[String]] = None,
    noradSatelliteID: Option[NoradSatelliteID] = None,
    satelliteArn: Option[SatelliteArn] = None,
    satelliteId: Option[Uuid] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.GetSatelliteResponse = {
    import GetSatelliteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.GetSatelliteResponse
      .builder()
      .optionallyWith(
        groundStations.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.groundStations)
      .optionallyWith(
        noradSatelliteID.map(value => NoradSatelliteID.unwrap(value): Integer)
      )(_.noradSatelliteID)
      .optionallyWith(
        satelliteArn.map(value => SatelliteArn.unwrap(value): java.lang.String)
      )(_.satelliteArn)
      .optionallyWith(
        satelliteId.map(value => Uuid.unwrap(value): java.lang.String)
      )(_.satelliteId)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.GetSatelliteResponse.ReadOnly =
    zio.aws.groundstation.model.GetSatelliteResponse.wrap(buildAwsValue())
}
object GetSatelliteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.GetSatelliteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.GetSatelliteResponse =
      zio.aws.groundstation.model.GetSatelliteResponse(
        groundStations.map(value => value),
        noradSatelliteID.map(value => value),
        satelliteArn.map(value => value),
        satelliteId.map(value => value)
      )
    def groundStations: Option[List[String]]
    def noradSatelliteID: Option[NoradSatelliteID]
    def satelliteArn: Option[SatelliteArn]
    def satelliteId: Option[Uuid]
    def getGroundStations: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("groundStations", groundStations)
    def getNoradSatelliteID: ZIO[Any, AwsError, NoradSatelliteID] =
      AwsError.unwrapOptionField("noradSatelliteID", noradSatelliteID)
    def getSatelliteArn: ZIO[Any, AwsError, SatelliteArn] =
      AwsError.unwrapOptionField("satelliteArn", satelliteArn)
    def getSatelliteId: ZIO[Any, AwsError, Uuid] =
      AwsError.unwrapOptionField("satelliteId", satelliteId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.GetSatelliteResponse
  ) extends zio.aws.groundstation.model.GetSatelliteResponse.ReadOnly {
    override val groundStations: Option[List[String]] = scala
      .Option(impl.groundStations())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val noradSatelliteID: Option[NoradSatelliteID] = scala
      .Option(impl.noradSatelliteID())
      .map(value =>
        zio.aws.groundstation.model.primitives.NoradSatelliteID(value)
      )
    override val satelliteArn: Option[SatelliteArn] = scala
      .Option(impl.satelliteArn())
      .map(value => zio.aws.groundstation.model.primitives.SatelliteArn(value))
    override val satelliteId: Option[Uuid] = scala
      .Option(impl.satelliteId())
      .map(value => zio.aws.groundstation.model.primitives.Uuid(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.GetSatelliteResponse
  ): zio.aws.groundstation.model.GetSatelliteResponse.ReadOnly = new Wrapper(
    impl
  )
}
