package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetMinuteUsageResponse(
    estimatedMinutesRemaining: Option[Integer] = None,
    isReservedMinutesCustomer: Option[Boolean] = None,
    totalReservedMinuteAllocation: Option[Integer] = None,
    totalScheduledMinutes: Option[Integer] = None,
    upcomingMinutesScheduled: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.GetMinuteUsageResponse = {
    import GetMinuteUsageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.GetMinuteUsageResponse
      .builder()
      .optionallyWith(
        estimatedMinutesRemaining.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.estimatedMinutesRemaining)
      .optionallyWith(
        isReservedMinutesCustomer.map(value => value: java.lang.Boolean)
      )(_.isReservedMinutesCustomer)
      .optionallyWith(
        totalReservedMinuteAllocation.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.totalReservedMinuteAllocation)
      .optionallyWith(
        totalScheduledMinutes.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.totalScheduledMinutes)
      .optionallyWith(
        upcomingMinutesScheduled.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.upcomingMinutesScheduled)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.GetMinuteUsageResponse.ReadOnly =
    zio.aws.groundstation.model.GetMinuteUsageResponse.wrap(buildAwsValue())
}
object GetMinuteUsageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.GetMinuteUsageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.GetMinuteUsageResponse =
      zio.aws.groundstation.model.GetMinuteUsageResponse(
        estimatedMinutesRemaining.map(value => value),
        isReservedMinutesCustomer.map(value => value),
        totalReservedMinuteAllocation.map(value => value),
        totalScheduledMinutes.map(value => value),
        upcomingMinutesScheduled.map(value => value)
      )
    def estimatedMinutesRemaining: Option[Integer]
    def isReservedMinutesCustomer: Option[Boolean]
    def totalReservedMinuteAllocation: Option[Integer]
    def totalScheduledMinutes: Option[Integer]
    def upcomingMinutesScheduled: Option[Integer]
    def getEstimatedMinutesRemaining: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("estimatedMinutesRemaining", estimatedMinutesRemaining)
    def getIsReservedMinutesCustomer: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("isReservedMinutesCustomer", isReservedMinutesCustomer)
    def getTotalReservedMinuteAllocation: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "totalReservedMinuteAllocation",
        totalReservedMinuteAllocation
      )
    def getTotalScheduledMinutes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalScheduledMinutes", totalScheduledMinutes)
    def getUpcomingMinutesScheduled: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("upcomingMinutesScheduled", upcomingMinutesScheduled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.GetMinuteUsageResponse
  ) extends zio.aws.groundstation.model.GetMinuteUsageResponse.ReadOnly {
    override val estimatedMinutesRemaining: Option[Integer] = scala
      .Option(impl.estimatedMinutesRemaining())
      .map(value => zio.aws.groundstation.model.primitives.Integer(value))
    override val isReservedMinutesCustomer: Option[Boolean] = scala
      .Option(impl.isReservedMinutesCustomer())
      .map(value => value: Boolean)
    override val totalReservedMinuteAllocation: Option[Integer] = scala
      .Option(impl.totalReservedMinuteAllocation())
      .map(value => zio.aws.groundstation.model.primitives.Integer(value))
    override val totalScheduledMinutes: Option[Integer] = scala
      .Option(impl.totalScheduledMinutes())
      .map(value => zio.aws.groundstation.model.primitives.Integer(value))
    override val upcomingMinutesScheduled: Option[Integer] = scala
      .Option(impl.upcomingMinutesScheduled())
      .map(value => zio.aws.groundstation.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.GetMinuteUsageResponse
  ): zio.aws.groundstation.model.GetMinuteUsageResponse.ReadOnly = new Wrapper(
    impl
  )
}
