package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.DataflowEndpointGroupArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetDataflowEndpointGroupResponse(
    dataflowEndpointGroupArn: Option[DataflowEndpointGroupArn] = None,
    dataflowEndpointGroupId: Option[String] = None,
    endpointsDetails: Option[
      Iterable[zio.aws.groundstation.model.EndpointDetails]
    ] = None,
    tags: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.GetDataflowEndpointGroupResponse = {
    import GetDataflowEndpointGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.GetDataflowEndpointGroupResponse
      .builder()
      .optionallyWith(
        dataflowEndpointGroupArn.map(value =>
          DataflowEndpointGroupArn.unwrap(value): java.lang.String
        )
      )(_.dataflowEndpointGroupArn)
      .optionallyWith(
        dataflowEndpointGroupId.map(value => value: java.lang.String)
      )(_.dataflowEndpointGroupId)
      .optionallyWith(
        endpointsDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpointsDetails)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.GetDataflowEndpointGroupResponse.ReadOnly =
    zio.aws.groundstation.model.GetDataflowEndpointGroupResponse
      .wrap(buildAwsValue())
}
object GetDataflowEndpointGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.GetDataflowEndpointGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.groundstation.model.GetDataflowEndpointGroupResponse =
      zio.aws.groundstation.model.GetDataflowEndpointGroupResponse(
        dataflowEndpointGroupArn.map(value => value),
        dataflowEndpointGroupId.map(value => value),
        endpointsDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value)
      )
    def dataflowEndpointGroupArn: Option[DataflowEndpointGroupArn]
    def dataflowEndpointGroupId: Option[String]
    def endpointsDetails
        : Option[List[zio.aws.groundstation.model.EndpointDetails.ReadOnly]]
    def tags: Option[Map[String, String]]
    def getDataflowEndpointGroupArn
        : ZIO[Any, AwsError, DataflowEndpointGroupArn] = AwsError
      .unwrapOptionField("dataflowEndpointGroupArn", dataflowEndpointGroupArn)
    def getDataflowEndpointGroupId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dataflowEndpointGroupId", dataflowEndpointGroupId)
    def getEndpointsDetails: ZIO[Any, AwsError, List[
      zio.aws.groundstation.model.EndpointDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("endpointsDetails", endpointsDetails)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.GetDataflowEndpointGroupResponse
  ) extends zio.aws.groundstation.model.GetDataflowEndpointGroupResponse.ReadOnly {
    override val dataflowEndpointGroupArn: Option[DataflowEndpointGroupArn] =
      scala
        .Option(impl.dataflowEndpointGroupArn())
        .map(value =>
          zio.aws.groundstation.model.primitives.DataflowEndpointGroupArn(value)
        )
    override val dataflowEndpointGroupId: Option[String] =
      scala.Option(impl.dataflowEndpointGroupId()).map(value => value: String)
    override val endpointsDetails
        : Option[List[zio.aws.groundstation.model.EndpointDetails.ReadOnly]] =
      scala
        .Option(impl.endpointsDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.groundstation.model.EndpointDetails.wrap(item)
          }.toList
        )
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.GetDataflowEndpointGroupResponse
  ): zio.aws.groundstation.model.GetDataflowEndpointGroupResponse.ReadOnly =
    new Wrapper(impl)
}
