package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EndpointDetails(
    endpoint: Option[zio.aws.groundstation.model.DataflowEndpoint] = None,
    securityDetails: Option[zio.aws.groundstation.model.SecurityDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.EndpointDetails = {
    import EndpointDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.EndpointDetails
      .builder()
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .optionallyWith(securityDetails.map(value => value.buildAwsValue()))(
        _.securityDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.EndpointDetails.ReadOnly =
    zio.aws.groundstation.model.EndpointDetails.wrap(buildAwsValue())
}
object EndpointDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.EndpointDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.EndpointDetails =
      zio.aws.groundstation.model.EndpointDetails(
        endpoint.map(value => value.asEditable),
        securityDetails.map(value => value.asEditable)
      )
    def endpoint: Option[zio.aws.groundstation.model.DataflowEndpoint.ReadOnly]
    def securityDetails
        : Option[zio.aws.groundstation.model.SecurityDetails.ReadOnly]
    def getEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.DataflowEndpoint.ReadOnly
    ] = AwsError.unwrapOptionField("endpoint", endpoint)
    def getSecurityDetails: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.SecurityDetails.ReadOnly
    ] = AwsError.unwrapOptionField("securityDetails", securityDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.EndpointDetails
  ) extends zio.aws.groundstation.model.EndpointDetails.ReadOnly {
    override val endpoint
        : Option[zio.aws.groundstation.model.DataflowEndpoint.ReadOnly] = scala
      .Option(impl.endpoint())
      .map(value => zio.aws.groundstation.model.DataflowEndpoint.wrap(value))
    override val securityDetails
        : Option[zio.aws.groundstation.model.SecurityDetails.ReadOnly] = scala
      .Option(impl.securityDetails())
      .map(value => zio.aws.groundstation.model.SecurityDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.EndpointDetails
  ): zio.aws.groundstation.model.EndpointDetails.ReadOnly = new Wrapper(impl)
}
