package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Destination(
    configDetails: Option[zio.aws.groundstation.model.ConfigDetails] = None,
    configId: Option[String] = None,
    configType: Option[zio.aws.groundstation.model.ConfigCapabilityType] = None,
    dataflowDestinationRegion: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.Destination = {
    import Destination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.Destination
      .builder()
      .optionallyWith(configDetails.map(value => value.buildAwsValue()))(
        _.configDetails
      )
      .optionallyWith(configId.map(value => value: java.lang.String))(
        _.configId
      )
      .optionallyWith(configType.map(value => value.unwrap))(_.configType)
      .optionallyWith(
        dataflowDestinationRegion.map(value => value: java.lang.String)
      )(_.dataflowDestinationRegion)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.Destination.ReadOnly =
    zio.aws.groundstation.model.Destination.wrap(buildAwsValue())
}
object Destination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.Destination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.Destination =
      zio.aws.groundstation.model.Destination(
        configDetails.map(value => value.asEditable),
        configId.map(value => value),
        configType.map(value => value),
        dataflowDestinationRegion.map(value => value)
      )
    def configDetails
        : Option[zio.aws.groundstation.model.ConfigDetails.ReadOnly]
    def configId: Option[String]
    def configType: Option[zio.aws.groundstation.model.ConfigCapabilityType]
    def dataflowDestinationRegion: Option[String]
    def getConfigDetails: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.ConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("configDetails", configDetails)
    def getConfigId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("configId", configId)
    def getConfigType
        : ZIO[Any, AwsError, zio.aws.groundstation.model.ConfigCapabilityType] =
      AwsError.unwrapOptionField("configType", configType)
    def getDataflowDestinationRegion: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dataflowDestinationRegion", dataflowDestinationRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.Destination
  ) extends zio.aws.groundstation.model.Destination.ReadOnly {
    override val configDetails
        : Option[zio.aws.groundstation.model.ConfigDetails.ReadOnly] = scala
      .Option(impl.configDetails())
      .map(value => zio.aws.groundstation.model.ConfigDetails.wrap(value))
    override val configId: Option[String] =
      scala.Option(impl.configId()).map(value => value: String)
    override val configType
        : Option[zio.aws.groundstation.model.ConfigCapabilityType] = scala
      .Option(impl.configType())
      .map(value =>
        zio.aws.groundstation.model.ConfigCapabilityType.wrap(value)
      )
    override val dataflowDestinationRegion: Option[String] =
      scala.Option(impl.dataflowDestinationRegion()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.Destination
  ): zio.aws.groundstation.model.Destination.ReadOnly = new Wrapper(impl)
}
