package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.JsonString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DemodulationConfig(unvalidatedJSON: JsonString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.DemodulationConfig = {
    import DemodulationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.DemodulationConfig
      .builder()
      .unvalidatedJSON(JsonString.unwrap(unvalidatedJSON): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.DemodulationConfig.ReadOnly =
    zio.aws.groundstation.model.DemodulationConfig.wrap(buildAwsValue())
}
object DemodulationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.DemodulationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.DemodulationConfig =
      zio.aws.groundstation.model.DemodulationConfig(unvalidatedJSON)
    def unvalidatedJSON: JsonString
    def getUnvalidatedJSON: ZIO[Any, Nothing, JsonString] =
      ZIO.succeed(unvalidatedJSON)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.DemodulationConfig
  ) extends zio.aws.groundstation.model.DemodulationConfig.ReadOnly {
    override val unvalidatedJSON: JsonString =
      zio.aws.groundstation.model.primitives.JsonString(impl.unvalidatedJSON())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.DemodulationConfig
  ): zio.aws.groundstation.model.DemodulationConfig.ReadOnly = new Wrapper(impl)
}
