package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteMissionProfileResponse(
    missionProfileId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.DeleteMissionProfileResponse = {
    import DeleteMissionProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.DeleteMissionProfileResponse
      .builder()
      .optionallyWith(missionProfileId.map(value => value: java.lang.String))(
        _.missionProfileId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.DeleteMissionProfileResponse.ReadOnly =
    zio.aws.groundstation.model.DeleteMissionProfileResponse
      .wrap(buildAwsValue())
}
object DeleteMissionProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.DeleteMissionProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.DeleteMissionProfileResponse =
      zio.aws.groundstation.model
        .DeleteMissionProfileResponse(missionProfileId.map(value => value))
    def missionProfileId: Option[String]
    def getMissionProfileId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("missionProfileId", missionProfileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.DeleteMissionProfileResponse
  ) extends zio.aws.groundstation.model.DeleteMissionProfileResponse.ReadOnly {
    override val missionProfileId: Option[String] =
      scala.Option(impl.missionProfileId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.DeleteMissionProfileResponse
  ): zio.aws.groundstation.model.DeleteMissionProfileResponse.ReadOnly =
    new Wrapper(impl)
}
