package zio.aws.groundstation.model
import java.lang.Integer
import zio.aws.groundstation.model.primitives.{
  SafeName,
  DataflowEndpointMtuInteger
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DataflowEndpoint(
    address: Option[zio.aws.groundstation.model.SocketAddress] = None,
    mtu: Option[DataflowEndpointMtuInteger] = None,
    name: Option[SafeName] = None,
    status: Option[zio.aws.groundstation.model.EndpointStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.DataflowEndpoint = {
    import DataflowEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.DataflowEndpoint
      .builder()
      .optionallyWith(address.map(value => value.buildAwsValue()))(_.address)
      .optionallyWith(
        mtu.map(value => DataflowEndpointMtuInteger.unwrap(value): Integer)
      )(_.mtu)
      .optionallyWith(
        name.map(value => SafeName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.DataflowEndpoint.ReadOnly =
    zio.aws.groundstation.model.DataflowEndpoint.wrap(buildAwsValue())
}
object DataflowEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.DataflowEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.DataflowEndpoint =
      zio.aws.groundstation.model.DataflowEndpoint(
        address.map(value => value.asEditable),
        mtu.map(value => value),
        name.map(value => value),
        status.map(value => value)
      )
    def address: Option[zio.aws.groundstation.model.SocketAddress.ReadOnly]
    def mtu: Option[DataflowEndpointMtuInteger]
    def name: Option[SafeName]
    def status: Option[zio.aws.groundstation.model.EndpointStatus]
    def getAddress: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.SocketAddress.ReadOnly
    ] = AwsError.unwrapOptionField("address", address)
    def getMtu: ZIO[Any, AwsError, DataflowEndpointMtuInteger] =
      AwsError.unwrapOptionField("mtu", mtu)
    def getName: ZIO[Any, AwsError, SafeName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.groundstation.model.EndpointStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.DataflowEndpoint
  ) extends zio.aws.groundstation.model.DataflowEndpoint.ReadOnly {
    override val address
        : Option[zio.aws.groundstation.model.SocketAddress.ReadOnly] = scala
      .Option(impl.address())
      .map(value => zio.aws.groundstation.model.SocketAddress.wrap(value))
    override val mtu: Option[DataflowEndpointMtuInteger] = scala
      .Option(impl.mtu())
      .map(value =>
        zio.aws.groundstation.model.primitives.DataflowEndpointMtuInteger(value)
      )
    override val name: Option[SafeName] = scala
      .Option(impl.name())
      .map(value => zio.aws.groundstation.model.primitives.SafeName(value))
    override val status: Option[zio.aws.groundstation.model.EndpointStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.groundstation.model.EndpointStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.DataflowEndpoint
  ): zio.aws.groundstation.model.DataflowEndpoint.ReadOnly = new Wrapper(impl)
}
