package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateMissionProfileResponse(
    missionProfileId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.CreateMissionProfileResponse = {
    import CreateMissionProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.CreateMissionProfileResponse
      .builder()
      .optionallyWith(missionProfileId.map(value => value: java.lang.String))(
        _.missionProfileId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.CreateMissionProfileResponse.ReadOnly =
    zio.aws.groundstation.model.CreateMissionProfileResponse
      .wrap(buildAwsValue())
}
object CreateMissionProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.CreateMissionProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.CreateMissionProfileResponse =
      zio.aws.groundstation.model
        .CreateMissionProfileResponse(missionProfileId.map(value => value))
    def missionProfileId: Option[String]
    def getMissionProfileId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("missionProfileId", missionProfileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.CreateMissionProfileResponse
  ) extends zio.aws.groundstation.model.CreateMissionProfileResponse.ReadOnly {
    override val missionProfileId: Option[String] =
      scala.Option(impl.missionProfileId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.CreateMissionProfileResponse
  ): zio.aws.groundstation.model.CreateMissionProfileResponse.ReadOnly =
    new Wrapper(impl)
}
