package zio.aws.groundstation.model
import scala.jdk.CollectionConverters._
sealed trait ContactStatus {
  def unwrap: software.amazon.awssdk.services.groundstation.model.ContactStatus
}
object ContactStatus {
  def wrap(
      value: software.amazon.awssdk.services.groundstation.model.ContactStatus
  ): zio.aws.groundstation.model.ContactStatus = value match {
    case software.amazon.awssdk.services.groundstation.model.ContactStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.groundstation.model.ContactStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.groundstation.model.ContactStatus.AWS_CANCELLED =>
      val r = AWS_CANCELLED
      r
    case software.amazon.awssdk.services.groundstation.model.ContactStatus.AWS_FAILED =>
      val r = AWS_FAILED
      r
    case software.amazon.awssdk.services.groundstation.model.ContactStatus.CANCELLED =>
      val r = CANCELLED
      r
    case software.amazon.awssdk.services.groundstation.model.ContactStatus.CANCELLING =>
      val r = CANCELLING
      r
    case software.amazon.awssdk.services.groundstation.model.ContactStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.groundstation.model.ContactStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.groundstation.model.ContactStatus.FAILED_TO_SCHEDULE =>
      val r = FAILED_TO_SCHEDULE
      r
    case software.amazon.awssdk.services.groundstation.model.ContactStatus.PASS =>
      val r = PASS
      r
    case software.amazon.awssdk.services.groundstation.model.ContactStatus.POSTPASS =>
      val r = POSTPASS
      r
    case software.amazon.awssdk.services.groundstation.model.ContactStatus.PREPASS =>
      val r = PREPASS
      r
    case software.amazon.awssdk.services.groundstation.model.ContactStatus.SCHEDULED =>
      val r = SCHEDULED
      r
    case software.amazon.awssdk.services.groundstation.model.ContactStatus.SCHEDULING =>
      val r = SCHEDULING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.groundstation.model.ContactStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ContactStatus =
      software.amazon.awssdk.services.groundstation.model.ContactStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object AVAILABLE extends zio.aws.groundstation.model.ContactStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ContactStatus =
      software.amazon.awssdk.services.groundstation.model.ContactStatus.AVAILABLE
  }
  case object AWS_CANCELLED extends zio.aws.groundstation.model.ContactStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ContactStatus =
      software.amazon.awssdk.services.groundstation.model.ContactStatus.AWS_CANCELLED
  }
  case object AWS_FAILED extends zio.aws.groundstation.model.ContactStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ContactStatus =
      software.amazon.awssdk.services.groundstation.model.ContactStatus.AWS_FAILED
  }
  case object CANCELLED extends zio.aws.groundstation.model.ContactStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ContactStatus =
      software.amazon.awssdk.services.groundstation.model.ContactStatus.CANCELLED
  }
  case object CANCELLING extends zio.aws.groundstation.model.ContactStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ContactStatus =
      software.amazon.awssdk.services.groundstation.model.ContactStatus.CANCELLING
  }
  case object COMPLETED extends zio.aws.groundstation.model.ContactStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ContactStatus =
      software.amazon.awssdk.services.groundstation.model.ContactStatus.COMPLETED
  }
  case object FAILED extends zio.aws.groundstation.model.ContactStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ContactStatus =
      software.amazon.awssdk.services.groundstation.model.ContactStatus.FAILED
  }
  case object FAILED_TO_SCHEDULE
      extends zio.aws.groundstation.model.ContactStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ContactStatus =
      software.amazon.awssdk.services.groundstation.model.ContactStatus.FAILED_TO_SCHEDULE
  }
  case object PASS extends zio.aws.groundstation.model.ContactStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ContactStatus =
      software.amazon.awssdk.services.groundstation.model.ContactStatus.PASS
  }
  case object POSTPASS extends zio.aws.groundstation.model.ContactStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ContactStatus =
      software.amazon.awssdk.services.groundstation.model.ContactStatus.POSTPASS
  }
  case object PREPASS extends zio.aws.groundstation.model.ContactStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ContactStatus =
      software.amazon.awssdk.services.groundstation.model.ContactStatus.PREPASS
  }
  case object SCHEDULED extends zio.aws.groundstation.model.ContactStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ContactStatus =
      software.amazon.awssdk.services.groundstation.model.ContactStatus.SCHEDULED
  }
  case object SCHEDULING extends zio.aws.groundstation.model.ContactStatus {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.ContactStatus =
      software.amazon.awssdk.services.groundstation.model.ContactStatus.SCHEDULING
  }
}
