package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.{
  SatelliteArn,
  MissionProfileArn,
  Timestamp
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ContactData(
    contactId: Option[String] = None,
    contactStatus: Option[zio.aws.groundstation.model.ContactStatus] = None,
    endTime: Option[Timestamp] = None,
    errorMessage: Option[String] = None,
    groundStation: Option[String] = None,
    maximumElevation: Option[zio.aws.groundstation.model.Elevation] = None,
    missionProfileArn: Option[MissionProfileArn] = None,
    postPassEndTime: Option[Timestamp] = None,
    prePassStartTime: Option[Timestamp] = None,
    region: Option[String] = None,
    satelliteArn: Option[SatelliteArn] = None,
    startTime: Option[Timestamp] = None,
    tags: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ContactData = {
    import ContactData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ContactData
      .builder()
      .optionallyWith(contactId.map(value => value: java.lang.String))(
        _.contactId
      )
      .optionallyWith(contactStatus.map(value => value.unwrap))(_.contactStatus)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(groundStation.map(value => value: java.lang.String))(
        _.groundStation
      )
      .optionallyWith(maximumElevation.map(value => value.buildAwsValue()))(
        _.maximumElevation
      )
      .optionallyWith(
        missionProfileArn.map(value =>
          MissionProfileArn.unwrap(value): java.lang.String
        )
      )(_.missionProfileArn)
      .optionallyWith(
        postPassEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.postPassEndTime)
      .optionallyWith(
        prePassStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.prePassStartTime)
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(
        satelliteArn.map(value => SatelliteArn.unwrap(value): java.lang.String)
      )(_.satelliteArn)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.ContactData.ReadOnly =
    zio.aws.groundstation.model.ContactData.wrap(buildAwsValue())
}
object ContactData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ContactData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ContactData =
      zio.aws.groundstation.model.ContactData(
        contactId.map(value => value),
        contactStatus.map(value => value),
        endTime.map(value => value),
        errorMessage.map(value => value),
        groundStation.map(value => value),
        maximumElevation.map(value => value.asEditable),
        missionProfileArn.map(value => value),
        postPassEndTime.map(value => value),
        prePassStartTime.map(value => value),
        region.map(value => value),
        satelliteArn.map(value => value),
        startTime.map(value => value),
        tags.map(value => value)
      )
    def contactId: Option[String]
    def contactStatus: Option[zio.aws.groundstation.model.ContactStatus]
    def endTime: Option[Timestamp]
    def errorMessage: Option[String]
    def groundStation: Option[String]
    def maximumElevation: Option[zio.aws.groundstation.model.Elevation.ReadOnly]
    def missionProfileArn: Option[MissionProfileArn]
    def postPassEndTime: Option[Timestamp]
    def prePassStartTime: Option[Timestamp]
    def region: Option[String]
    def satelliteArn: Option[SatelliteArn]
    def startTime: Option[Timestamp]
    def tags: Option[Map[String, String]]
    def getContactId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("contactId", contactId)
    def getContactStatus
        : ZIO[Any, AwsError, zio.aws.groundstation.model.ContactStatus] =
      AwsError.unwrapOptionField("contactStatus", contactStatus)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getGroundStation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groundStation", groundStation)
    def getMaximumElevation
        : ZIO[Any, AwsError, zio.aws.groundstation.model.Elevation.ReadOnly] =
      AwsError.unwrapOptionField("maximumElevation", maximumElevation)
    def getMissionProfileArn: ZIO[Any, AwsError, MissionProfileArn] =
      AwsError.unwrapOptionField("missionProfileArn", missionProfileArn)
    def getPostPassEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("postPassEndTime", postPassEndTime)
    def getPrePassStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("prePassStartTime", prePassStartTime)
    def getRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("region", region)
    def getSatelliteArn: ZIO[Any, AwsError, SatelliteArn] =
      AwsError.unwrapOptionField("satelliteArn", satelliteArn)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ContactData
  ) extends zio.aws.groundstation.model.ContactData.ReadOnly {
    override val contactId: Option[String] =
      scala.Option(impl.contactId()).map(value => value: String)
    override val contactStatus
        : Option[zio.aws.groundstation.model.ContactStatus] = scala
      .Option(impl.contactStatus())
      .map(value => zio.aws.groundstation.model.ContactStatus.wrap(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.groundstation.model.primitives.Timestamp(value))
    override val errorMessage: Option[String] =
      scala.Option(impl.errorMessage()).map(value => value: String)
    override val groundStation: Option[String] =
      scala.Option(impl.groundStation()).map(value => value: String)
    override val maximumElevation
        : Option[zio.aws.groundstation.model.Elevation.ReadOnly] = scala
      .Option(impl.maximumElevation())
      .map(value => zio.aws.groundstation.model.Elevation.wrap(value))
    override val missionProfileArn: Option[MissionProfileArn] = scala
      .Option(impl.missionProfileArn())
      .map(value =>
        zio.aws.groundstation.model.primitives.MissionProfileArn(value)
      )
    override val postPassEndTime: Option[Timestamp] = scala
      .Option(impl.postPassEndTime())
      .map(value => zio.aws.groundstation.model.primitives.Timestamp(value))
    override val prePassStartTime: Option[Timestamp] = scala
      .Option(impl.prePassStartTime())
      .map(value => zio.aws.groundstation.model.primitives.Timestamp(value))
    override val region: Option[String] =
      scala.Option(impl.region()).map(value => value: String)
    override val satelliteArn: Option[SatelliteArn] = scala
      .Option(impl.satelliteArn())
      .map(value => zio.aws.groundstation.model.primitives.SatelliteArn(value))
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.groundstation.model.primitives.Timestamp(value))
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ContactData
  ): zio.aws.groundstation.model.ContactData.ReadOnly = new Wrapper(impl)
}
