package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ConfigTypeData(
    antennaDownlinkConfig: Option[
      zio.aws.groundstation.model.AntennaDownlinkConfig
    ] = None,
    antennaDownlinkDemodDecodeConfig: Option[
      zio.aws.groundstation.model.AntennaDownlinkDemodDecodeConfig
    ] = None,
    antennaUplinkConfig: Option[
      zio.aws.groundstation.model.AntennaUplinkConfig
    ] = None,
    dataflowEndpointConfig: Option[
      zio.aws.groundstation.model.DataflowEndpointConfig
    ] = None,
    s3RecordingConfig: Option[zio.aws.groundstation.model.S3RecordingConfig] =
      None,
    trackingConfig: Option[zio.aws.groundstation.model.TrackingConfig] = None,
    uplinkEchoConfig: Option[zio.aws.groundstation.model.UplinkEchoConfig] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ConfigTypeData = {
    import ConfigTypeData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ConfigTypeData
      .builder()
      .optionallyWith(
        antennaDownlinkConfig.map(value => value.buildAwsValue())
      )(_.antennaDownlinkConfig)
      .optionallyWith(
        antennaDownlinkDemodDecodeConfig.map(value => value.buildAwsValue())
      )(_.antennaDownlinkDemodDecodeConfig)
      .optionallyWith(antennaUplinkConfig.map(value => value.buildAwsValue()))(
        _.antennaUplinkConfig
      )
      .optionallyWith(
        dataflowEndpointConfig.map(value => value.buildAwsValue())
      )(_.dataflowEndpointConfig)
      .optionallyWith(s3RecordingConfig.map(value => value.buildAwsValue()))(
        _.s3RecordingConfig
      )
      .optionallyWith(trackingConfig.map(value => value.buildAwsValue()))(
        _.trackingConfig
      )
      .optionallyWith(uplinkEchoConfig.map(value => value.buildAwsValue()))(
        _.uplinkEchoConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.ConfigTypeData.ReadOnly =
    zio.aws.groundstation.model.ConfigTypeData.wrap(buildAwsValue())
}
object ConfigTypeData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ConfigTypeData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ConfigTypeData =
      zio.aws.groundstation.model.ConfigTypeData(
        antennaDownlinkConfig.map(value => value.asEditable),
        antennaDownlinkDemodDecodeConfig.map(value => value.asEditable),
        antennaUplinkConfig.map(value => value.asEditable),
        dataflowEndpointConfig.map(value => value.asEditable),
        s3RecordingConfig.map(value => value.asEditable),
        trackingConfig.map(value => value.asEditable),
        uplinkEchoConfig.map(value => value.asEditable)
      )
    def antennaDownlinkConfig
        : Option[zio.aws.groundstation.model.AntennaDownlinkConfig.ReadOnly]
    def antennaDownlinkDemodDecodeConfig: Option[
      zio.aws.groundstation.model.AntennaDownlinkDemodDecodeConfig.ReadOnly
    ]
    def antennaUplinkConfig
        : Option[zio.aws.groundstation.model.AntennaUplinkConfig.ReadOnly]
    def dataflowEndpointConfig
        : Option[zio.aws.groundstation.model.DataflowEndpointConfig.ReadOnly]
    def s3RecordingConfig
        : Option[zio.aws.groundstation.model.S3RecordingConfig.ReadOnly]
    def trackingConfig
        : Option[zio.aws.groundstation.model.TrackingConfig.ReadOnly]
    def uplinkEchoConfig
        : Option[zio.aws.groundstation.model.UplinkEchoConfig.ReadOnly]
    def getAntennaDownlinkConfig: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.AntennaDownlinkConfig.ReadOnly
    ] =
      AwsError.unwrapOptionField("antennaDownlinkConfig", antennaDownlinkConfig)
    def getAntennaDownlinkDemodDecodeConfig: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.AntennaDownlinkDemodDecodeConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "antennaDownlinkDemodDecodeConfig",
      antennaDownlinkDemodDecodeConfig
    )
    def getAntennaUplinkConfig: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.AntennaUplinkConfig.ReadOnly
    ] = AwsError.unwrapOptionField("antennaUplinkConfig", antennaUplinkConfig)
    def getDataflowEndpointConfig: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.DataflowEndpointConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataflowEndpointConfig",
      dataflowEndpointConfig
    )
    def getS3RecordingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.S3RecordingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("s3RecordingConfig", s3RecordingConfig)
    def getTrackingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.TrackingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("trackingConfig", trackingConfig)
    def getUplinkEchoConfig: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.UplinkEchoConfig.ReadOnly
    ] = AwsError.unwrapOptionField("uplinkEchoConfig", uplinkEchoConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ConfigTypeData
  ) extends zio.aws.groundstation.model.ConfigTypeData.ReadOnly {
    override val antennaDownlinkConfig
        : Option[zio.aws.groundstation.model.AntennaDownlinkConfig.ReadOnly] =
      scala
        .Option(impl.antennaDownlinkConfig())
        .map(value =>
          zio.aws.groundstation.model.AntennaDownlinkConfig.wrap(value)
        )
    override val antennaDownlinkDemodDecodeConfig: Option[
      zio.aws.groundstation.model.AntennaDownlinkDemodDecodeConfig.ReadOnly
    ] = scala
      .Option(impl.antennaDownlinkDemodDecodeConfig())
      .map(value =>
        zio.aws.groundstation.model.AntennaDownlinkDemodDecodeConfig.wrap(value)
      )
    override val antennaUplinkConfig
        : Option[zio.aws.groundstation.model.AntennaUplinkConfig.ReadOnly] =
      scala
        .Option(impl.antennaUplinkConfig())
        .map(value =>
          zio.aws.groundstation.model.AntennaUplinkConfig.wrap(value)
        )
    override val dataflowEndpointConfig
        : Option[zio.aws.groundstation.model.DataflowEndpointConfig.ReadOnly] =
      scala
        .Option(impl.dataflowEndpointConfig())
        .map(value =>
          zio.aws.groundstation.model.DataflowEndpointConfig.wrap(value)
        )
    override val s3RecordingConfig
        : Option[zio.aws.groundstation.model.S3RecordingConfig.ReadOnly] = scala
      .Option(impl.s3RecordingConfig())
      .map(value => zio.aws.groundstation.model.S3RecordingConfig.wrap(value))
    override val trackingConfig
        : Option[zio.aws.groundstation.model.TrackingConfig.ReadOnly] = scala
      .Option(impl.trackingConfig())
      .map(value => zio.aws.groundstation.model.TrackingConfig.wrap(value))
    override val uplinkEchoConfig
        : Option[zio.aws.groundstation.model.UplinkEchoConfig.ReadOnly] = scala
      .Option(impl.uplinkEchoConfig())
      .map(value => zio.aws.groundstation.model.UplinkEchoConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ConfigTypeData
  ): zio.aws.groundstation.model.ConfigTypeData.ReadOnly = new Wrapper(impl)
}
