package zio.aws.grafana.model
import zio.prelude.data.Optional
import zio.aws.grafana.model.primitives.{
  WorkspaceId,
  PaginationToken,
  ListVersionsRequestMaxResultsInteger
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListVersionsRequest(
    maxResults: Optional[ListVersionsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    workspaceId: Optional[WorkspaceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.ListVersionsRequest = {
    import ListVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.ListVersionsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListVersionsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        workspaceId.map(value => WorkspaceId.unwrap(value): java.lang.String)
      )(_.workspaceId)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.ListVersionsRequest.ReadOnly =
    zio.aws.grafana.model.ListVersionsRequest.wrap(buildAwsValue())
}
object ListVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.ListVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.ListVersionsRequest =
      zio.aws.grafana.model.ListVersionsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        workspaceId.map(value => value)
      )
    def maxResults: Optional[ListVersionsRequestMaxResultsInteger]
    def nextToken: Optional[PaginationToken]
    def workspaceId: Optional[WorkspaceId]
    def getMaxResults
        : ZIO[Any, AwsError, ListVersionsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkspaceId: ZIO[Any, AwsError, WorkspaceId] =
      AwsError.unwrapOptionField("workspaceId", workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.ListVersionsRequest
  ) extends zio.aws.grafana.model.ListVersionsRequest.ReadOnly {
    override val maxResults: Optional[ListVersionsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.grafana.model.primitives
            .ListVersionsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.grafana.model.primitives.PaginationToken(value))
    override val workspaceId: Optional[WorkspaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.workspaceId())
      .map(value => zio.aws.grafana.model.primitives.WorkspaceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.ListVersionsRequest
  ): zio.aws.grafana.model.ListVersionsRequest.ReadOnly = new Wrapper(impl)
}
