package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.grafana.model.primitives.{
  GrafanaVersion,
  OverridableConfigurationJson
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspaceConfigurationResponse(
    configuration: OverridableConfigurationJson,
    grafanaVersion: Optional[GrafanaVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.DescribeWorkspaceConfigurationResponse = {
    import DescribeWorkspaceConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.DescribeWorkspaceConfigurationResponse
      .builder()
      .configuration(
        OverridableConfigurationJson.unwrap(configuration): java.lang.String
      )
      .optionallyWith(
        grafanaVersion.map(value =>
          GrafanaVersion.unwrap(value): java.lang.String
        )
      )(_.grafanaVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.grafana.model.DescribeWorkspaceConfigurationResponse.ReadOnly =
    zio.aws.grafana.model.DescribeWorkspaceConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeWorkspaceConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.DescribeWorkspaceConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.grafana.model.DescribeWorkspaceConfigurationResponse =
      zio.aws.grafana.model.DescribeWorkspaceConfigurationResponse(
        configuration,
        grafanaVersion.map(value => value)
      )
    def configuration: OverridableConfigurationJson
    def grafanaVersion: Optional[GrafanaVersion]
    def getConfiguration: ZIO[Any, Nothing, OverridableConfigurationJson] =
      ZIO.succeed(configuration)
    def getGrafanaVersion: ZIO[Any, AwsError, GrafanaVersion] =
      AwsError.unwrapOptionField("grafanaVersion", grafanaVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.DescribeWorkspaceConfigurationResponse
  ) extends zio.aws.grafana.model.DescribeWorkspaceConfigurationResponse.ReadOnly {
    override val configuration: OverridableConfigurationJson =
      zio.aws.grafana.model.primitives
        .OverridableConfigurationJson(impl.configuration())
    override val grafanaVersion: Optional[GrafanaVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grafanaVersion())
        .map(value => zio.aws.grafana.model.primitives.GrafanaVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.DescribeWorkspaceConfigurationResponse
  ): zio.aws.grafana.model.DescribeWorkspaceConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
