package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.grafana.model.primitives.{
  WorkspaceId,
  GrafanaVersion,
  OverridableConfigurationJson
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateWorkspaceConfigurationRequest(
    configuration: OverridableConfigurationJson,
    grafanaVersion: Optional[GrafanaVersion] = Optional.Absent,
    workspaceId: WorkspaceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.UpdateWorkspaceConfigurationRequest = {
    import UpdateWorkspaceConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.UpdateWorkspaceConfigurationRequest
      .builder()
      .configuration(
        OverridableConfigurationJson.unwrap(configuration): java.lang.String
      )
      .optionallyWith(
        grafanaVersion.map(value =>
          GrafanaVersion.unwrap(value): java.lang.String
        )
      )(_.grafanaVersion)
      .workspaceId(WorkspaceId.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.grafana.model.UpdateWorkspaceConfigurationRequest.ReadOnly =
    zio.aws.grafana.model.UpdateWorkspaceConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateWorkspaceConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.UpdateWorkspaceConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.UpdateWorkspaceConfigurationRequest =
      zio.aws.grafana.model.UpdateWorkspaceConfigurationRequest(
        configuration,
        grafanaVersion.map(value => value),
        workspaceId
      )
    def configuration: OverridableConfigurationJson
    def grafanaVersion: Optional[GrafanaVersion]
    def workspaceId: WorkspaceId
    def getConfiguration: ZIO[Any, Nothing, OverridableConfigurationJson] =
      ZIO.succeed(configuration)
    def getGrafanaVersion: ZIO[Any, AwsError, GrafanaVersion] =
      AwsError.unwrapOptionField("grafanaVersion", grafanaVersion)
    def getWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.UpdateWorkspaceConfigurationRequest
  ) extends zio.aws.grafana.model.UpdateWorkspaceConfigurationRequest.ReadOnly {
    override val configuration: OverridableConfigurationJson =
      zio.aws.grafana.model.primitives
        .OverridableConfigurationJson(impl.configuration())
    override val grafanaVersion: Optional[GrafanaVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grafanaVersion())
        .map(value => zio.aws.grafana.model.primitives.GrafanaVersion(value))
    override val workspaceId: WorkspaceId =
      zio.aws.grafana.model.primitives.WorkspaceId(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.UpdateWorkspaceConfigurationRequest
  ): zio.aws.grafana.model.UpdateWorkspaceConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
