package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.grafana.model.primitives.WorkspaceId
import scala.jdk.CollectionConverters.*
final case class AssociateLicenseRequest(
    licenseType: zio.aws.grafana.model.LicenseType,
    workspaceId: WorkspaceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.AssociateLicenseRequest = {
    import AssociateLicenseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.AssociateLicenseRequest
      .builder()
      .licenseType(licenseType.unwrap)
      .workspaceId(WorkspaceId.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.AssociateLicenseRequest.ReadOnly =
    zio.aws.grafana.model.AssociateLicenseRequest.wrap(buildAwsValue())
}
object AssociateLicenseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.AssociateLicenseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.AssociateLicenseRequest =
      zio.aws.grafana.model.AssociateLicenseRequest(licenseType, workspaceId)
    def licenseType: zio.aws.grafana.model.LicenseType
    def workspaceId: WorkspaceId
    def getLicenseType: ZIO[Any, Nothing, zio.aws.grafana.model.LicenseType] =
      ZIO.succeed(licenseType)
    def getWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.AssociateLicenseRequest
  ) extends zio.aws.grafana.model.AssociateLicenseRequest.ReadOnly {
    override val licenseType: zio.aws.grafana.model.LicenseType =
      zio.aws.grafana.model.LicenseType.wrap(impl.licenseType())
    override val workspaceId: WorkspaceId =
      zio.aws.grafana.model.primitives.WorkspaceId(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.AssociateLicenseRequest
  ): zio.aws.grafana.model.AssociateLicenseRequest.ReadOnly = new Wrapper(impl)
}
