package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.grafana.model.primitives.{
  WorkspaceId,
  OverridableConfigurationJson
}
import scala.jdk.CollectionConverters.*
final case class UpdateWorkspaceConfigurationRequest(
    configuration: OverridableConfigurationJson,
    workspaceId: WorkspaceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.UpdateWorkspaceConfigurationRequest = {
    import UpdateWorkspaceConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.UpdateWorkspaceConfigurationRequest
      .builder()
      .configuration(
        OverridableConfigurationJson.unwrap(configuration): java.lang.String
      )
      .workspaceId(WorkspaceId.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.grafana.model.UpdateWorkspaceConfigurationRequest.ReadOnly =
    zio.aws.grafana.model.UpdateWorkspaceConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateWorkspaceConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.UpdateWorkspaceConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.UpdateWorkspaceConfigurationRequest =
      zio.aws.grafana.model
        .UpdateWorkspaceConfigurationRequest(configuration, workspaceId)
    def configuration: OverridableConfigurationJson
    def workspaceId: WorkspaceId
    def getConfiguration: ZIO[Any, Nothing, OverridableConfigurationJson] =
      ZIO.succeed(configuration)
    def getWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.UpdateWorkspaceConfigurationRequest
  ) extends zio.aws.grafana.model.UpdateWorkspaceConfigurationRequest.ReadOnly {
    override val configuration: OverridableConfigurationJson =
      zio.aws.grafana.model.primitives
        .OverridableConfigurationJson(impl.configuration())
    override val workspaceId: WorkspaceId =
      zio.aws.grafana.model.primitives.WorkspaceId(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.UpdateWorkspaceConfigurationRequest
  ): zio.aws.grafana.model.UpdateWorkspaceConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
