package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.grafana.model.primitives.{
  IamRoleArn,
  OverridableConfigurationJson,
  OrganizationRoleName,
  OrganizationalUnit,
  StackSetName,
  TagValue,
  WorkspaceName,
  Description,
  ClientToken,
  GrafanaVersion,
  TagKey
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateWorkspaceRequest(
    accountAccessType: zio.aws.grafana.model.AccountAccessType,
    authenticationProviders: Iterable[
      zio.aws.grafana.model.AuthenticationProviderTypes
    ],
    clientToken: Optional[ClientToken] = Optional.Absent,
    configuration: Optional[OverridableConfigurationJson] = Optional.Absent,
    grafanaVersion: Optional[GrafanaVersion] = Optional.Absent,
    networkAccessControl: Optional[
      zio.aws.grafana.model.NetworkAccessConfiguration
    ] = Optional.Absent,
    organizationRoleName: Optional[OrganizationRoleName] = Optional.Absent,
    permissionType: zio.aws.grafana.model.PermissionType,
    stackSetName: Optional[StackSetName] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    vpcConfiguration: Optional[zio.aws.grafana.model.VpcConfiguration] =
      Optional.Absent,
    workspaceDataSources: Optional[
      Iterable[zio.aws.grafana.model.DataSourceType]
    ] = Optional.Absent,
    workspaceDescription: Optional[Description] = Optional.Absent,
    workspaceName: Optional[WorkspaceName] = Optional.Absent,
    workspaceNotificationDestinations: Optional[
      Iterable[zio.aws.grafana.model.NotificationDestinationType]
    ] = Optional.Absent,
    workspaceOrganizationalUnits: Optional[Iterable[OrganizationalUnit]] =
      Optional.Absent,
    workspaceRoleArn: Optional[IamRoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.CreateWorkspaceRequest = {
    import CreateWorkspaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.CreateWorkspaceRequest
      .builder()
      .accountAccessType(accountAccessType.unwrap)
      .authenticationProvidersWithStrings(authenticationProviders.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        configuration.map(value =>
          OverridableConfigurationJson.unwrap(value): java.lang.String
        )
      )(_.configuration)
      .optionallyWith(
        grafanaVersion.map(value =>
          GrafanaVersion.unwrap(value): java.lang.String
        )
      )(_.grafanaVersion)
      .optionallyWith(networkAccessControl.map(value => value.buildAwsValue()))(
        _.networkAccessControl
      )
      .optionallyWith(
        organizationRoleName.map(value =>
          OrganizationRoleName.unwrap(value): java.lang.String
        )
      )(_.organizationRoleName)
      .permissionType(permissionType.unwrap)
      .optionallyWith(
        stackSetName.map(value => StackSetName.unwrap(value): java.lang.String)
      )(_.stackSetName)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .optionallyWith(
        workspaceDataSources.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.workspaceDataSourcesWithStrings)
      .optionallyWith(
        workspaceDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.workspaceDescription)
      .optionallyWith(
        workspaceName.map(value =>
          WorkspaceName.unwrap(value): java.lang.String
        )
      )(_.workspaceName)
      .optionallyWith(
        workspaceNotificationDestinations.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.workspaceNotificationDestinationsWithStrings)
      .optionallyWith(
        workspaceOrganizationalUnits.map(value =>
          value.map { item =>
            OrganizationalUnit.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.workspaceOrganizationalUnits)
      .optionallyWith(
        workspaceRoleArn.map(value =>
          IamRoleArn.unwrap(value): java.lang.String
        )
      )(_.workspaceRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.CreateWorkspaceRequest.ReadOnly =
    zio.aws.grafana.model.CreateWorkspaceRequest.wrap(buildAwsValue())
}
object CreateWorkspaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.CreateWorkspaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.CreateWorkspaceRequest =
      zio.aws.grafana.model.CreateWorkspaceRequest(
        accountAccessType,
        authenticationProviders,
        clientToken.map(value => value),
        configuration.map(value => value),
        grafanaVersion.map(value => value),
        networkAccessControl.map(value => value.asEditable),
        organizationRoleName.map(value => value),
        permissionType,
        stackSetName.map(value => value),
        tags.map(value => value),
        vpcConfiguration.map(value => value.asEditable),
        workspaceDataSources.map(value => value),
        workspaceDescription.map(value => value),
        workspaceName.map(value => value),
        workspaceNotificationDestinations.map(value => value),
        workspaceOrganizationalUnits.map(value => value),
        workspaceRoleArn.map(value => value)
      )
    def accountAccessType: zio.aws.grafana.model.AccountAccessType
    def authenticationProviders
        : List[zio.aws.grafana.model.AuthenticationProviderTypes]
    def clientToken: Optional[ClientToken]
    def configuration: Optional[OverridableConfigurationJson]
    def grafanaVersion: Optional[GrafanaVersion]
    def networkAccessControl
        : Optional[zio.aws.grafana.model.NetworkAccessConfiguration.ReadOnly]
    def organizationRoleName: Optional[OrganizationRoleName]
    def permissionType: zio.aws.grafana.model.PermissionType
    def stackSetName: Optional[StackSetName]
    def tags: Optional[Map[TagKey, TagValue]]
    def vpcConfiguration
        : Optional[zio.aws.grafana.model.VpcConfiguration.ReadOnly]
    def workspaceDataSources
        : Optional[List[zio.aws.grafana.model.DataSourceType]]
    def workspaceDescription: Optional[Description]
    def workspaceName: Optional[WorkspaceName]
    def workspaceNotificationDestinations
        : Optional[List[zio.aws.grafana.model.NotificationDestinationType]]
    def workspaceOrganizationalUnits: Optional[List[OrganizationalUnit]]
    def workspaceRoleArn: Optional[IamRoleArn]
    def getAccountAccessType
        : ZIO[Any, Nothing, zio.aws.grafana.model.AccountAccessType] =
      ZIO.succeed(accountAccessType)
    def getAuthenticationProviders: ZIO[Any, Nothing, List[
      zio.aws.grafana.model.AuthenticationProviderTypes
    ]] = ZIO.succeed(authenticationProviders)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getConfiguration: ZIO[Any, AwsError, OverridableConfigurationJson] =
      AwsError.unwrapOptionField("configuration", configuration)
    def getGrafanaVersion: ZIO[Any, AwsError, GrafanaVersion] =
      AwsError.unwrapOptionField("grafanaVersion", grafanaVersion)
    def getNetworkAccessControl: ZIO[
      Any,
      AwsError,
      zio.aws.grafana.model.NetworkAccessConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("networkAccessControl", networkAccessControl)
    def getOrganizationRoleName: ZIO[Any, AwsError, OrganizationRoleName] =
      AwsError.unwrapOptionField("organizationRoleName", organizationRoleName)
    def getPermissionType
        : ZIO[Any, Nothing, zio.aws.grafana.model.PermissionType] =
      ZIO.succeed(permissionType)
    def getStackSetName: ZIO[Any, AwsError, StackSetName] =
      AwsError.unwrapOptionField("stackSetName", stackSetName)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcConfiguration
        : ZIO[Any, AwsError, zio.aws.grafana.model.VpcConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
    def getWorkspaceDataSources
        : ZIO[Any, AwsError, List[zio.aws.grafana.model.DataSourceType]] =
      AwsError.unwrapOptionField("workspaceDataSources", workspaceDataSources)
    def getWorkspaceDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("workspaceDescription", workspaceDescription)
    def getWorkspaceName: ZIO[Any, AwsError, WorkspaceName] =
      AwsError.unwrapOptionField("workspaceName", workspaceName)
    def getWorkspaceNotificationDestinations: ZIO[Any, AwsError, List[
      zio.aws.grafana.model.NotificationDestinationType
    ]] = AwsError.unwrapOptionField(
      "workspaceNotificationDestinations",
      workspaceNotificationDestinations
    )
    def getWorkspaceOrganizationalUnits
        : ZIO[Any, AwsError, List[OrganizationalUnit]] =
      AwsError.unwrapOptionField(
        "workspaceOrganizationalUnits",
        workspaceOrganizationalUnits
      )
    def getWorkspaceRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("workspaceRoleArn", workspaceRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.CreateWorkspaceRequest
  ) extends zio.aws.grafana.model.CreateWorkspaceRequest.ReadOnly {
    override val accountAccessType: zio.aws.grafana.model.AccountAccessType =
      zio.aws.grafana.model.AccountAccessType.wrap(impl.accountAccessType())
    override val authenticationProviders
        : List[zio.aws.grafana.model.AuthenticationProviderTypes] = impl
      .authenticationProviders()
      .asScala
      .map { item =>
        zio.aws.grafana.model.AuthenticationProviderTypes.wrap(item)
      }
      .toList
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.grafana.model.primitives.ClientToken(value))
    override val configuration: Optional[OverridableConfigurationJson] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value =>
          zio.aws.grafana.model.primitives.OverridableConfigurationJson(value)
        )
    override val grafanaVersion: Optional[GrafanaVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grafanaVersion())
        .map(value => zio.aws.grafana.model.primitives.GrafanaVersion(value))
    override val networkAccessControl
        : Optional[zio.aws.grafana.model.NetworkAccessConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkAccessControl())
        .map(value =>
          zio.aws.grafana.model.NetworkAccessConfiguration.wrap(value)
        )
    override val organizationRoleName: Optional[OrganizationRoleName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationRoleName())
        .map(value =>
          zio.aws.grafana.model.primitives.OrganizationRoleName(value)
        )
    override val permissionType: zio.aws.grafana.model.PermissionType =
      zio.aws.grafana.model.PermissionType.wrap(impl.permissionType())
    override val stackSetName: Optional[StackSetName] = zio.aws.core.internal
      .optionalFromNullable(impl.stackSetName())
      .map(value => zio.aws.grafana.model.primitives.StackSetName(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.grafana.model.primitives
              .TagKey(key) -> zio.aws.grafana.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val vpcConfiguration
        : Optional[zio.aws.grafana.model.VpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfiguration())
        .map(value => zio.aws.grafana.model.VpcConfiguration.wrap(value))
    override val workspaceDataSources
        : Optional[List[zio.aws.grafana.model.DataSourceType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workspaceDataSources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.grafana.model.DataSourceType.wrap(item)
          }.toList
        )
    override val workspaceDescription: Optional[Description] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workspaceDescription())
        .map(value => zio.aws.grafana.model.primitives.Description(value))
    override val workspaceName: Optional[WorkspaceName] = zio.aws.core.internal
      .optionalFromNullable(impl.workspaceName())
      .map(value => zio.aws.grafana.model.primitives.WorkspaceName(value))
    override val workspaceNotificationDestinations
        : Optional[List[zio.aws.grafana.model.NotificationDestinationType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workspaceNotificationDestinations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.grafana.model.NotificationDestinationType.wrap(item)
          }.toList
        )
    override val workspaceOrganizationalUnits
        : Optional[List[OrganizationalUnit]] = zio.aws.core.internal
      .optionalFromNullable(impl.workspaceOrganizationalUnits())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.grafana.model.primitives.OrganizationalUnit(item)
        }.toList
      )
    override val workspaceRoleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.workspaceRoleArn())
      .map(value => zio.aws.grafana.model.primitives.IamRoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.CreateWorkspaceRequest
  ): zio.aws.grafana.model.CreateWorkspaceRequest.ReadOnly = new Wrapper(impl)
}
