package zio.aws.grafana
import zio.prelude.Subtype
import zio.aws.grafana.model.primitives.{
  SubnetId,
  SecurityGroupId,
  OrganizationalUnit,
  TagValue,
  AllowedOrganization,
  RoleValue,
  GrafanaVersion,
  VpceId,
  PrefixListId,
  TagKey
}
import java.time.Instant
import zio.aws.grafana.model.primitives.ApiKeyToken.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AllowedOrganization extends Subtype[String]
    type AllowedOrganization =
      zio.aws.grafana.model.primitives.AllowedOrganization.Type
    object ApiKeyName extends Subtype[String]
    type ApiKeyName = zio.aws.grafana.model.primitives.ApiKeyName.Type
    object ApiKeyToken extends Subtype[String]
    type ApiKeyToken = zio.aws.grafana.model.primitives.ApiKeyToken.Type
    object AssertionAttribute extends Subtype[String]
    type AssertionAttribute =
      zio.aws.grafana.model.primitives.AssertionAttribute.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.grafana.model.primitives.ClientToken.Type
    object CreateWorkspaceApiKeyRequestSecondsToLiveInteger extends Subtype[Int]
    type CreateWorkspaceApiKeyRequestSecondsToLiveInteger =
      zio.aws.grafana.model.primitives.CreateWorkspaceApiKeyRequestSecondsToLiveInteger.Type
    object Description extends Subtype[String]
    type Description = zio.aws.grafana.model.primitives.Description.Type
    object Endpoint extends Subtype[String]
    type Endpoint = zio.aws.grafana.model.primitives.Endpoint.Type
    object GrafanaVersion extends Subtype[String]
    type GrafanaVersion = zio.aws.grafana.model.primitives.GrafanaVersion.Type
    object IamRoleArn extends Subtype[String]
    type IamRoleArn = zio.aws.grafana.model.primitives.IamRoleArn.Type
    object IdpMetadataUrl extends Subtype[String]
    type IdpMetadataUrl = zio.aws.grafana.model.primitives.IdpMetadataUrl.Type
    object ListPermissionsRequestMaxResultsInteger extends Subtype[Int]
    type ListPermissionsRequestMaxResultsInteger =
      zio.aws.grafana.model.primitives.ListPermissionsRequestMaxResultsInteger.Type
    object ListVersionsRequestMaxResultsInteger extends Subtype[Int]
    type ListVersionsRequestMaxResultsInteger =
      zio.aws.grafana.model.primitives.ListVersionsRequestMaxResultsInteger.Type
    object ListWorkspacesRequestMaxResultsInteger extends Subtype[Int]
    type ListWorkspacesRequestMaxResultsInteger =
      zio.aws.grafana.model.primitives.ListWorkspacesRequestMaxResultsInteger.Type
    object LoginValidityDuration extends Subtype[Int]
    type LoginValidityDuration =
      zio.aws.grafana.model.primitives.LoginValidityDuration.Type
    object OrganizationRoleName extends Subtype[String]
    type OrganizationRoleName =
      zio.aws.grafana.model.primitives.OrganizationRoleName.Type
    object OrganizationalUnit extends Subtype[String]
    type OrganizationalUnit =
      zio.aws.grafana.model.primitives.OrganizationalUnit.Type
    object OverridableConfigurationJson extends Subtype[String]
    type OverridableConfigurationJson =
      zio.aws.grafana.model.primitives.OverridableConfigurationJson.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken = zio.aws.grafana.model.primitives.PaginationToken.Type
    object PrefixListId extends Subtype[String]
    type PrefixListId = zio.aws.grafana.model.primitives.PrefixListId.Type
    object RoleValue extends Subtype[String]
    type RoleValue = zio.aws.grafana.model.primitives.RoleValue.Type
    object SSOClientId extends Subtype[String]
    type SSOClientId = zio.aws.grafana.model.primitives.SSOClientId.Type
    object SecurityGroupId extends Subtype[String]
    type SecurityGroupId = zio.aws.grafana.model.primitives.SecurityGroupId.Type
    object SsoId extends Subtype[String]
    type SsoId = zio.aws.grafana.model.primitives.SsoId.Type
    object StackSetName extends Subtype[String]
    type StackSetName = zio.aws.grafana.model.primitives.StackSetName.Type
    object SubnetId extends Subtype[String]
    type SubnetId = zio.aws.grafana.model.primitives.SubnetId.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.grafana.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.grafana.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.grafana.model.primitives.Timestamp.Type
    object UpdateErrorCodeInteger extends Subtype[Int]
    type UpdateErrorCodeInteger =
      zio.aws.grafana.model.primitives.UpdateErrorCodeInteger.Type
    object VpceId extends Subtype[String]
    type VpceId = zio.aws.grafana.model.primitives.VpceId.Type
    object WorkspaceId extends Subtype[String]
    type WorkspaceId = zio.aws.grafana.model.primitives.WorkspaceId.Type
    object WorkspaceName extends Subtype[String]
    type WorkspaceName = zio.aws.grafana.model.primitives.WorkspaceName.Type
  }
  type AllowedOrganizations = List[AllowedOrganization]
  type AuthenticationProviders =
    List[zio.aws.grafana.model.AuthenticationProviderTypes]
  type DataSourceTypesList = List[zio.aws.grafana.model.DataSourceType]
  type GrafanaVersionList = List[GrafanaVersion]
  type NotificationDestinationsList =
    List[zio.aws.grafana.model.NotificationDestinationType]
  type OrganizationalUnitList = List[OrganizationalUnit]
  type PermissionEntryList = List[zio.aws.grafana.model.PermissionEntry]
  type PrefixListIds = List[PrefixListId]
  type RoleValueList = List[RoleValue]
  type SecurityGroupIds = List[SecurityGroupId]
  type SubnetIds = List[SubnetId]
  type TagKeys = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type UpdateErrorList = List[zio.aws.grafana.model.UpdateError]
  type UpdateInstructionBatch = List[zio.aws.grafana.model.UpdateInstruction]
  type UserList = List[zio.aws.grafana.model.User]
  type VpceIds = List[VpceId]
  type WorkspaceList = List[zio.aws.grafana.model.WorkspaceSummary]
}
