package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.grafana.model.primitives.{
  IamRoleArn,
  OrganizationRoleName,
  OrganizationalUnit,
  StackSetName,
  WorkspaceName,
  WorkspaceId,
  Description
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateWorkspaceRequest(
    accountAccessType: Optional[zio.aws.grafana.model.AccountAccessType] =
      Optional.Absent,
    organizationRoleName: Optional[OrganizationRoleName] = Optional.Absent,
    permissionType: Optional[zio.aws.grafana.model.PermissionType] =
      Optional.Absent,
    removeVpcConfiguration: Optional[Boolean] = Optional.Absent,
    stackSetName: Optional[StackSetName] = Optional.Absent,
    vpcConfiguration: Optional[zio.aws.grafana.model.VpcConfiguration] =
      Optional.Absent,
    workspaceDataSources: Optional[
      Iterable[zio.aws.grafana.model.DataSourceType]
    ] = Optional.Absent,
    workspaceDescription: Optional[Description] = Optional.Absent,
    workspaceId: WorkspaceId,
    workspaceName: Optional[WorkspaceName] = Optional.Absent,
    workspaceNotificationDestinations: Optional[
      Iterable[zio.aws.grafana.model.NotificationDestinationType]
    ] = Optional.Absent,
    workspaceOrganizationalUnits: Optional[Iterable[OrganizationalUnit]] =
      Optional.Absent,
    workspaceRoleArn: Optional[IamRoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.UpdateWorkspaceRequest = {
    import UpdateWorkspaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.UpdateWorkspaceRequest
      .builder()
      .optionallyWith(accountAccessType.map(value => value.unwrap))(
        _.accountAccessType
      )
      .optionallyWith(
        organizationRoleName.map(value =>
          OrganizationRoleName.unwrap(value): java.lang.String
        )
      )(_.organizationRoleName)
      .optionallyWith(permissionType.map(value => value.unwrap))(
        _.permissionType
      )
      .optionallyWith(
        removeVpcConfiguration.map(value => value: java.lang.Boolean)
      )(_.removeVpcConfiguration)
      .optionallyWith(
        stackSetName.map(value => StackSetName.unwrap(value): java.lang.String)
      )(_.stackSetName)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .optionallyWith(
        workspaceDataSources.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.workspaceDataSourcesWithStrings)
      .optionallyWith(
        workspaceDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.workspaceDescription)
      .workspaceId(WorkspaceId.unwrap(workspaceId): java.lang.String)
      .optionallyWith(
        workspaceName.map(value =>
          WorkspaceName.unwrap(value): java.lang.String
        )
      )(_.workspaceName)
      .optionallyWith(
        workspaceNotificationDestinations.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.workspaceNotificationDestinationsWithStrings)
      .optionallyWith(
        workspaceOrganizationalUnits.map(value =>
          value.map { item =>
            OrganizationalUnit.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.workspaceOrganizationalUnits)
      .optionallyWith(
        workspaceRoleArn.map(value =>
          IamRoleArn.unwrap(value): java.lang.String
        )
      )(_.workspaceRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.UpdateWorkspaceRequest.ReadOnly =
    zio.aws.grafana.model.UpdateWorkspaceRequest.wrap(buildAwsValue())
}
object UpdateWorkspaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.UpdateWorkspaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.UpdateWorkspaceRequest =
      zio.aws.grafana.model.UpdateWorkspaceRequest(
        accountAccessType.map(value => value),
        organizationRoleName.map(value => value),
        permissionType.map(value => value),
        removeVpcConfiguration.map(value => value),
        stackSetName.map(value => value),
        vpcConfiguration.map(value => value.asEditable),
        workspaceDataSources.map(value => value),
        workspaceDescription.map(value => value),
        workspaceId,
        workspaceName.map(value => value),
        workspaceNotificationDestinations.map(value => value),
        workspaceOrganizationalUnits.map(value => value),
        workspaceRoleArn.map(value => value)
      )
    def accountAccessType: Optional[zio.aws.grafana.model.AccountAccessType]
    def organizationRoleName: Optional[OrganizationRoleName]
    def permissionType: Optional[zio.aws.grafana.model.PermissionType]
    def removeVpcConfiguration: Optional[Boolean]
    def stackSetName: Optional[StackSetName]
    def vpcConfiguration
        : Optional[zio.aws.grafana.model.VpcConfiguration.ReadOnly]
    def workspaceDataSources
        : Optional[List[zio.aws.grafana.model.DataSourceType]]
    def workspaceDescription: Optional[Description]
    def workspaceId: WorkspaceId
    def workspaceName: Optional[WorkspaceName]
    def workspaceNotificationDestinations
        : Optional[List[zio.aws.grafana.model.NotificationDestinationType]]
    def workspaceOrganizationalUnits: Optional[List[OrganizationalUnit]]
    def workspaceRoleArn: Optional[IamRoleArn]
    def getAccountAccessType
        : ZIO[Any, AwsError, zio.aws.grafana.model.AccountAccessType] =
      AwsError.unwrapOptionField("accountAccessType", accountAccessType)
    def getOrganizationRoleName: ZIO[Any, AwsError, OrganizationRoleName] =
      AwsError.unwrapOptionField("organizationRoleName", organizationRoleName)
    def getPermissionType
        : ZIO[Any, AwsError, zio.aws.grafana.model.PermissionType] =
      AwsError.unwrapOptionField("permissionType", permissionType)
    def getRemoveVpcConfiguration: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("removeVpcConfiguration", removeVpcConfiguration)
    def getStackSetName: ZIO[Any, AwsError, StackSetName] =
      AwsError.unwrapOptionField("stackSetName", stackSetName)
    def getVpcConfiguration
        : ZIO[Any, AwsError, zio.aws.grafana.model.VpcConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
    def getWorkspaceDataSources
        : ZIO[Any, AwsError, List[zio.aws.grafana.model.DataSourceType]] =
      AwsError.unwrapOptionField("workspaceDataSources", workspaceDataSources)
    def getWorkspaceDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("workspaceDescription", workspaceDescription)
    def getWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceId)
    def getWorkspaceName: ZIO[Any, AwsError, WorkspaceName] =
      AwsError.unwrapOptionField("workspaceName", workspaceName)
    def getWorkspaceNotificationDestinations: ZIO[Any, AwsError, List[
      zio.aws.grafana.model.NotificationDestinationType
    ]] = AwsError.unwrapOptionField(
      "workspaceNotificationDestinations",
      workspaceNotificationDestinations
    )
    def getWorkspaceOrganizationalUnits
        : ZIO[Any, AwsError, List[OrganizationalUnit]] =
      AwsError.unwrapOptionField(
        "workspaceOrganizationalUnits",
        workspaceOrganizationalUnits
      )
    def getWorkspaceRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("workspaceRoleArn", workspaceRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.UpdateWorkspaceRequest
  ) extends zio.aws.grafana.model.UpdateWorkspaceRequest.ReadOnly {
    override val accountAccessType
        : Optional[zio.aws.grafana.model.AccountAccessType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountAccessType())
        .map(value => zio.aws.grafana.model.AccountAccessType.wrap(value))
    override val organizationRoleName: Optional[OrganizationRoleName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationRoleName())
        .map(value =>
          zio.aws.grafana.model.primitives.OrganizationRoleName(value)
        )
    override val permissionType
        : Optional[zio.aws.grafana.model.PermissionType] = zio.aws.core.internal
      .optionalFromNullable(impl.permissionType())
      .map(value => zio.aws.grafana.model.PermissionType.wrap(value))
    override val removeVpcConfiguration: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeVpcConfiguration())
        .map(value => value: Boolean)
    override val stackSetName: Optional[StackSetName] = zio.aws.core.internal
      .optionalFromNullable(impl.stackSetName())
      .map(value => zio.aws.grafana.model.primitives.StackSetName(value))
    override val vpcConfiguration
        : Optional[zio.aws.grafana.model.VpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfiguration())
        .map(value => zio.aws.grafana.model.VpcConfiguration.wrap(value))
    override val workspaceDataSources
        : Optional[List[zio.aws.grafana.model.DataSourceType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workspaceDataSources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.grafana.model.DataSourceType.wrap(item)
          }.toList
        )
    override val workspaceDescription: Optional[Description] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workspaceDescription())
        .map(value => zio.aws.grafana.model.primitives.Description(value))
    override val workspaceId: WorkspaceId =
      zio.aws.grafana.model.primitives.WorkspaceId(impl.workspaceId())
    override val workspaceName: Optional[WorkspaceName] = zio.aws.core.internal
      .optionalFromNullable(impl.workspaceName())
      .map(value => zio.aws.grafana.model.primitives.WorkspaceName(value))
    override val workspaceNotificationDestinations
        : Optional[List[zio.aws.grafana.model.NotificationDestinationType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workspaceNotificationDestinations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.grafana.model.NotificationDestinationType.wrap(item)
          }.toList
        )
    override val workspaceOrganizationalUnits
        : Optional[List[OrganizationalUnit]] = zio.aws.core.internal
      .optionalFromNullable(impl.workspaceOrganizationalUnits())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.grafana.model.primitives.OrganizationalUnit(item)
        }.toList
      )
    override val workspaceRoleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.workspaceRoleArn())
      .map(value => zio.aws.grafana.model.primitives.IamRoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.UpdateWorkspaceRequest
  ): zio.aws.grafana.model.UpdateWorkspaceRequest.ReadOnly = new Wrapper(impl)
}
