package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspaceAuthenticationResponse(
    authentication: zio.aws.grafana.model.AuthenticationDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationResponse = {
    import DescribeWorkspaceAuthenticationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationResponse
      .builder()
      .authentication(authentication.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.grafana.model.DescribeWorkspaceAuthenticationResponse.ReadOnly =
    zio.aws.grafana.model.DescribeWorkspaceAuthenticationResponse
      .wrap(buildAwsValue())
}
object DescribeWorkspaceAuthenticationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.grafana.model.DescribeWorkspaceAuthenticationResponse =
      zio.aws.grafana.model
        .DescribeWorkspaceAuthenticationResponse(authentication.asEditable)
    def authentication: zio.aws.grafana.model.AuthenticationDescription.ReadOnly
    def getAuthentication: ZIO[
      Any,
      Nothing,
      zio.aws.grafana.model.AuthenticationDescription.ReadOnly
    ] = ZIO.succeed(authentication)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationResponse
  ) extends zio.aws.grafana.model.DescribeWorkspaceAuthenticationResponse.ReadOnly {
    override val authentication
        : zio.aws.grafana.model.AuthenticationDescription.ReadOnly =
      zio.aws.grafana.model.AuthenticationDescription
        .wrap(impl.authentication())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationResponse
  ): zio.aws.grafana.model.DescribeWorkspaceAuthenticationResponse.ReadOnly =
    new Wrapper(impl)
}
