package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.grafana.model.primitives.WorkspaceId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateWorkspaceAuthenticationRequest(
    authenticationProviders: Iterable[
      zio.aws.grafana.model.AuthenticationProviderTypes
    ],
    samlConfiguration: Optional[zio.aws.grafana.model.SamlConfiguration] =
      Optional.Absent,
    workspaceId: WorkspaceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationRequest = {
    import UpdateWorkspaceAuthenticationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationRequest
      .builder()
      .authenticationProvidersWithStrings(authenticationProviders.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(samlConfiguration.map(value => value.buildAwsValue()))(
        _.samlConfiguration
      )
      .workspaceId(WorkspaceId.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.grafana.model.UpdateWorkspaceAuthenticationRequest.ReadOnly =
    zio.aws.grafana.model.UpdateWorkspaceAuthenticationRequest
      .wrap(buildAwsValue())
}
object UpdateWorkspaceAuthenticationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.UpdateWorkspaceAuthenticationRequest =
      zio.aws.grafana.model.UpdateWorkspaceAuthenticationRequest(
        authenticationProviders,
        samlConfiguration.map(value => value.asEditable),
        workspaceId
      )
    def authenticationProviders
        : List[zio.aws.grafana.model.AuthenticationProviderTypes]
    def samlConfiguration
        : Optional[zio.aws.grafana.model.SamlConfiguration.ReadOnly]
    def workspaceId: WorkspaceId
    def getAuthenticationProviders: ZIO[Any, Nothing, List[
      zio.aws.grafana.model.AuthenticationProviderTypes
    ]] = ZIO.succeed(authenticationProviders)
    def getSamlConfiguration
        : ZIO[Any, AwsError, zio.aws.grafana.model.SamlConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("samlConfiguration", samlConfiguration)
    def getWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationRequest
  ) extends zio.aws.grafana.model.UpdateWorkspaceAuthenticationRequest.ReadOnly {
    override val authenticationProviders
        : List[zio.aws.grafana.model.AuthenticationProviderTypes] = impl
      .authenticationProviders()
      .asScala
      .map { item =>
        zio.aws.grafana.model.AuthenticationProviderTypes.wrap(item)
      }
      .toList
    override val samlConfiguration
        : Optional[zio.aws.grafana.model.SamlConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.samlConfiguration())
        .map(value => zio.aws.grafana.model.SamlConfiguration.wrap(value))
    override val workspaceId: WorkspaceId =
      zio.aws.grafana.model.primitives.WorkspaceId(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationRequest
  ): zio.aws.grafana.model.UpdateWorkspaceAuthenticationRequest.ReadOnly =
    new Wrapper(impl)
}
