package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.grafana.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: String,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.TagResourceRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.TagResourceRequest.ReadOnly =
    zio.aws.grafana.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.TagResourceRequest =
      zio.aws.grafana.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: String
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.TagResourceRequest
  ) extends zio.aws.grafana.model.TagResourceRequest.ReadOnly {
    override val resourceArn: String = impl.resourceArn(): String
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.grafana.model.primitives
          .TagKey(key) -> zio.aws.grafana.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.TagResourceRequest
  ): zio.aws.grafana.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
