package zio.aws.grafana.model
import scala.jdk.CollectionConverters.*
sealed trait PermissionType {
  def unwrap: software.amazon.awssdk.services.grafana.model.PermissionType
}
object PermissionType {
  def wrap(
      value: software.amazon.awssdk.services.grafana.model.PermissionType
  ): zio.aws.grafana.model.PermissionType = value match {
    case software.amazon.awssdk.services.grafana.model.PermissionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.grafana.model.PermissionType.CUSTOMER_MANAGED =>
      val r = CUSTOMER_MANAGED
      r
    case software.amazon.awssdk.services.grafana.model.PermissionType.SERVICE_MANAGED =>
      val r = SERVICE_MANAGED
      r
  }
  case object unknownToSdkVersion extends zio.aws.grafana.model.PermissionType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.PermissionType =
      software.amazon.awssdk.services.grafana.model.PermissionType.UNKNOWN_TO_SDK_VERSION
  }
  case object CUSTOMER_MANAGED extends zio.aws.grafana.model.PermissionType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.PermissionType =
      software.amazon.awssdk.services.grafana.model.PermissionType.CUSTOMER_MANAGED
  }
  case object SERVICE_MANAGED extends zio.aws.grafana.model.PermissionType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.PermissionType =
      software.amazon.awssdk.services.grafana.model.PermissionType.SERVICE_MANAGED
  }
}
