package zio.aws.grafana.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.grafana.model.primitives.{
  IamRoleArn,
  OrganizationRoleName,
  OrganizationalUnit,
  StackSetName,
  Timestamp,
  TagValue,
  WorkspaceName,
  WorkspaceId,
  Description,
  Endpoint,
  GrafanaVersion,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class WorkspaceDescription(
    accountAccessType: Optional[zio.aws.grafana.model.AccountAccessType] =
      Optional.Absent,
    authentication: zio.aws.grafana.model.AuthenticationSummary,
    created: Timestamp,
    dataSources: Iterable[zio.aws.grafana.model.DataSourceType],
    description: Optional[Description] = Optional.Absent,
    endpoint: Endpoint,
    freeTrialConsumed: Optional[Boolean] = Optional.Absent,
    freeTrialExpiration: Optional[Timestamp] = Optional.Absent,
    grafanaVersion: GrafanaVersion,
    id: WorkspaceId,
    licenseExpiration: Optional[Timestamp] = Optional.Absent,
    licenseType: Optional[zio.aws.grafana.model.LicenseType] = Optional.Absent,
    modified: Timestamp,
    name: Optional[WorkspaceName] = Optional.Absent,
    notificationDestinations: Optional[
      Iterable[zio.aws.grafana.model.NotificationDestinationType]
    ] = Optional.Absent,
    organizationRoleName: Optional[OrganizationRoleName] = Optional.Absent,
    organizationalUnits: Optional[Iterable[OrganizationalUnit]] =
      Optional.Absent,
    permissionType: Optional[zio.aws.grafana.model.PermissionType] =
      Optional.Absent,
    stackSetName: Optional[StackSetName] = Optional.Absent,
    status: zio.aws.grafana.model.WorkspaceStatus,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    workspaceRoleArn: Optional[IamRoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.WorkspaceDescription = {
    import WorkspaceDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.WorkspaceDescription
      .builder()
      .optionallyWith(accountAccessType.map(value => value.unwrap))(
        _.accountAccessType
      )
      .authentication(authentication.buildAwsValue())
      .created(Timestamp.unwrap(created): Instant)
      .dataSourcesWithStrings(dataSources.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .endpoint(Endpoint.unwrap(endpoint): java.lang.String)
      .optionallyWith(freeTrialConsumed.map(value => value: java.lang.Boolean))(
        _.freeTrialConsumed
      )
      .optionallyWith(
        freeTrialExpiration.map(value => Timestamp.unwrap(value): Instant)
      )(_.freeTrialExpiration)
      .grafanaVersion(GrafanaVersion.unwrap(grafanaVersion): java.lang.String)
      .id(WorkspaceId.unwrap(id): java.lang.String)
      .optionallyWith(
        licenseExpiration.map(value => Timestamp.unwrap(value): Instant)
      )(_.licenseExpiration)
      .optionallyWith(licenseType.map(value => value.unwrap))(_.licenseType)
      .modified(Timestamp.unwrap(modified): Instant)
      .optionallyWith(
        name.map(value => WorkspaceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        notificationDestinations.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.notificationDestinationsWithStrings)
      .optionallyWith(
        organizationRoleName.map(value =>
          OrganizationRoleName.unwrap(value): java.lang.String
        )
      )(_.organizationRoleName)
      .optionallyWith(
        organizationalUnits.map(value =>
          value.map { item =>
            OrganizationalUnit.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.organizationalUnits)
      .optionallyWith(permissionType.map(value => value.unwrap))(
        _.permissionType
      )
      .optionallyWith(
        stackSetName.map(value => StackSetName.unwrap(value): java.lang.String)
      )(_.stackSetName)
      .status(status.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        workspaceRoleArn.map(value =>
          IamRoleArn.unwrap(value): java.lang.String
        )
      )(_.workspaceRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.WorkspaceDescription.ReadOnly =
    zio.aws.grafana.model.WorkspaceDescription.wrap(buildAwsValue())
}
object WorkspaceDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.WorkspaceDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.WorkspaceDescription =
      zio.aws.grafana.model.WorkspaceDescription(
        accountAccessType.map(value => value),
        authentication.asEditable,
        created,
        dataSources,
        description.map(value => value),
        endpoint,
        freeTrialConsumed.map(value => value),
        freeTrialExpiration.map(value => value),
        grafanaVersion,
        id,
        licenseExpiration.map(value => value),
        licenseType.map(value => value),
        modified,
        name.map(value => value),
        notificationDestinations.map(value => value),
        organizationRoleName.map(value => value),
        organizationalUnits.map(value => value),
        permissionType.map(value => value),
        stackSetName.map(value => value),
        status,
        tags.map(value => value),
        workspaceRoleArn.map(value => value)
      )
    def accountAccessType: Optional[zio.aws.grafana.model.AccountAccessType]
    def authentication: zio.aws.grafana.model.AuthenticationSummary.ReadOnly
    def created: Timestamp
    def dataSources: List[zio.aws.grafana.model.DataSourceType]
    def description: Optional[Description]
    def endpoint: Endpoint
    def freeTrialConsumed: Optional[Boolean]
    def freeTrialExpiration: Optional[Timestamp]
    def grafanaVersion: GrafanaVersion
    def id: WorkspaceId
    def licenseExpiration: Optional[Timestamp]
    def licenseType: Optional[zio.aws.grafana.model.LicenseType]
    def modified: Timestamp
    def name: Optional[WorkspaceName]
    def notificationDestinations
        : Optional[List[zio.aws.grafana.model.NotificationDestinationType]]
    def organizationRoleName: Optional[OrganizationRoleName]
    def organizationalUnits: Optional[List[OrganizationalUnit]]
    def permissionType: Optional[zio.aws.grafana.model.PermissionType]
    def stackSetName: Optional[StackSetName]
    def status: zio.aws.grafana.model.WorkspaceStatus
    def tags: Optional[Map[TagKey, TagValue]]
    def workspaceRoleArn: Optional[IamRoleArn]
    def getAccountAccessType
        : ZIO[Any, AwsError, zio.aws.grafana.model.AccountAccessType] =
      AwsError.unwrapOptionField("accountAccessType", accountAccessType)
    def getAuthentication: ZIO[
      Any,
      Nothing,
      zio.aws.grafana.model.AuthenticationSummary.ReadOnly
    ] = ZIO.succeed(authentication)
    def getCreated: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(created)
    def getDataSources
        : ZIO[Any, Nothing, List[zio.aws.grafana.model.DataSourceType]] =
      ZIO.succeed(dataSources)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEndpoint: ZIO[Any, Nothing, Endpoint] = ZIO.succeed(endpoint)
    def getFreeTrialConsumed: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("freeTrialConsumed", freeTrialConsumed)
    def getFreeTrialExpiration: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("freeTrialExpiration", freeTrialExpiration)
    def getGrafanaVersion: ZIO[Any, Nothing, GrafanaVersion] =
      ZIO.succeed(grafanaVersion)
    def getId: ZIO[Any, Nothing, WorkspaceId] = ZIO.succeed(id)
    def getLicenseExpiration: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("licenseExpiration", licenseExpiration)
    def getLicenseType: ZIO[Any, AwsError, zio.aws.grafana.model.LicenseType] =
      AwsError.unwrapOptionField("licenseType", licenseType)
    def getModified: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(modified)
    def getName: ZIO[Any, AwsError, WorkspaceName] =
      AwsError.unwrapOptionField("name", name)
    def getNotificationDestinations: ZIO[Any, AwsError, List[
      zio.aws.grafana.model.NotificationDestinationType
    ]] = AwsError.unwrapOptionField(
      "notificationDestinations",
      notificationDestinations
    )
    def getOrganizationRoleName: ZIO[Any, AwsError, OrganizationRoleName] =
      AwsError.unwrapOptionField("organizationRoleName", organizationRoleName)
    def getOrganizationalUnits: ZIO[Any, AwsError, List[OrganizationalUnit]] =
      AwsError.unwrapOptionField("organizationalUnits", organizationalUnits)
    def getPermissionType
        : ZIO[Any, AwsError, zio.aws.grafana.model.PermissionType] =
      AwsError.unwrapOptionField("permissionType", permissionType)
    def getStackSetName: ZIO[Any, AwsError, StackSetName] =
      AwsError.unwrapOptionField("stackSetName", stackSetName)
    def getStatus: ZIO[Any, Nothing, zio.aws.grafana.model.WorkspaceStatus] =
      ZIO.succeed(status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWorkspaceRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("workspaceRoleArn", workspaceRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.WorkspaceDescription
  ) extends zio.aws.grafana.model.WorkspaceDescription.ReadOnly {
    override val accountAccessType
        : Optional[zio.aws.grafana.model.AccountAccessType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountAccessType())
        .map(value => zio.aws.grafana.model.AccountAccessType.wrap(value))
    override val authentication
        : zio.aws.grafana.model.AuthenticationSummary.ReadOnly =
      zio.aws.grafana.model.AuthenticationSummary.wrap(impl.authentication())
    override val created: Timestamp =
      zio.aws.grafana.model.primitives.Timestamp(impl.created())
    override val dataSources: List[zio.aws.grafana.model.DataSourceType] = impl
      .dataSources()
      .asScala
      .map { item =>
        zio.aws.grafana.model.DataSourceType.wrap(item)
      }
      .toList
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.grafana.model.primitives.Description(value))
    override val endpoint: Endpoint =
      zio.aws.grafana.model.primitives.Endpoint(impl.endpoint())
    override val freeTrialConsumed: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.freeTrialConsumed())
      .map(value => value: Boolean)
    override val freeTrialExpiration: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.freeTrialExpiration())
        .map(value => zio.aws.grafana.model.primitives.Timestamp(value))
    override val grafanaVersion: GrafanaVersion =
      zio.aws.grafana.model.primitives.GrafanaVersion(impl.grafanaVersion())
    override val id: WorkspaceId =
      zio.aws.grafana.model.primitives.WorkspaceId(impl.id())
    override val licenseExpiration: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseExpiration())
      .map(value => zio.aws.grafana.model.primitives.Timestamp(value))
    override val licenseType: Optional[zio.aws.grafana.model.LicenseType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.licenseType())
        .map(value => zio.aws.grafana.model.LicenseType.wrap(value))
    override val modified: Timestamp =
      zio.aws.grafana.model.primitives.Timestamp(impl.modified())
    override val name: Optional[WorkspaceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.grafana.model.primitives.WorkspaceName(value))
    override val notificationDestinations
        : Optional[List[zio.aws.grafana.model.NotificationDestinationType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationDestinations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.grafana.model.NotificationDestinationType.wrap(item)
          }.toList
        )
    override val organizationRoleName: Optional[OrganizationRoleName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationRoleName())
        .map(value =>
          zio.aws.grafana.model.primitives.OrganizationRoleName(value)
        )
    override val organizationalUnits: Optional[List[OrganizationalUnit]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationalUnits())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.grafana.model.primitives.OrganizationalUnit(item)
          }.toList
        )
    override val permissionType
        : Optional[zio.aws.grafana.model.PermissionType] = zio.aws.core.internal
      .optionalFromNullable(impl.permissionType())
      .map(value => zio.aws.grafana.model.PermissionType.wrap(value))
    override val stackSetName: Optional[StackSetName] = zio.aws.core.internal
      .optionalFromNullable(impl.stackSetName())
      .map(value => zio.aws.grafana.model.primitives.StackSetName(value))
    override val status: zio.aws.grafana.model.WorkspaceStatus =
      zio.aws.grafana.model.WorkspaceStatus.wrap(impl.status())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.grafana.model.primitives
              .TagKey(key) -> zio.aws.grafana.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val workspaceRoleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.workspaceRoleArn())
      .map(value => zio.aws.grafana.model.primitives.IamRoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.WorkspaceDescription
  ): zio.aws.grafana.model.WorkspaceDescription.ReadOnly = new Wrapper(impl)
}
