package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.grafana.model.primitives.WorkspaceId
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspaceRequest(workspaceId: WorkspaceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.DescribeWorkspaceRequest = {
    import DescribeWorkspaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.DescribeWorkspaceRequest
      .builder()
      .workspaceId(WorkspaceId.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.DescribeWorkspaceRequest.ReadOnly =
    zio.aws.grafana.model.DescribeWorkspaceRequest.wrap(buildAwsValue())
}
object DescribeWorkspaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.DescribeWorkspaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.DescribeWorkspaceRequest =
      zio.aws.grafana.model.DescribeWorkspaceRequest(workspaceId)
    def workspaceId: WorkspaceId
    def getWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.DescribeWorkspaceRequest
  ) extends zio.aws.grafana.model.DescribeWorkspaceRequest.ReadOnly {
    override val workspaceId: WorkspaceId =
      zio.aws.grafana.model.primitives.WorkspaceId(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.DescribeWorkspaceRequest
  ): zio.aws.grafana.model.DescribeWorkspaceRequest.ReadOnly = new Wrapper(impl)
}
