package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.grafana.model.primitives.WorkspaceId
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspaceAuthenticationRequest(
    workspaceId: WorkspaceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationRequest = {
    import DescribeWorkspaceAuthenticationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationRequest
      .builder()
      .workspaceId(WorkspaceId.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.grafana.model.DescribeWorkspaceAuthenticationRequest.ReadOnly =
    zio.aws.grafana.model.DescribeWorkspaceAuthenticationRequest
      .wrap(buildAwsValue())
}
object DescribeWorkspaceAuthenticationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.grafana.model.DescribeWorkspaceAuthenticationRequest =
      zio.aws.grafana.model.DescribeWorkspaceAuthenticationRequest(workspaceId)
    def workspaceId: WorkspaceId
    def getWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationRequest
  ) extends zio.aws.grafana.model.DescribeWorkspaceAuthenticationRequest.ReadOnly {
    override val workspaceId: WorkspaceId =
      zio.aws.grafana.model.primitives.WorkspaceId(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationRequest
  ): zio.aws.grafana.model.DescribeWorkspaceAuthenticationRequest.ReadOnly =
    new Wrapper(impl)
}
