package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteWorkspaceResponse(
    workspace: zio.aws.grafana.model.WorkspaceDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.DeleteWorkspaceResponse = {
    import DeleteWorkspaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.DeleteWorkspaceResponse
      .builder()
      .workspace(workspace.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.DeleteWorkspaceResponse.ReadOnly =
    zio.aws.grafana.model.DeleteWorkspaceResponse.wrap(buildAwsValue())
}
object DeleteWorkspaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.DeleteWorkspaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.DeleteWorkspaceResponse =
      zio.aws.grafana.model.DeleteWorkspaceResponse(workspace.asEditable)
    def workspace: zio.aws.grafana.model.WorkspaceDescription.ReadOnly
    def getWorkspace: ZIO[
      Any,
      Nothing,
      zio.aws.grafana.model.WorkspaceDescription.ReadOnly
    ] = ZIO.succeed(workspace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.DeleteWorkspaceResponse
  ) extends zio.aws.grafana.model.DeleteWorkspaceResponse.ReadOnly {
    override val workspace
        : zio.aws.grafana.model.WorkspaceDescription.ReadOnly =
      zio.aws.grafana.model.WorkspaceDescription.wrap(impl.workspace())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.DeleteWorkspaceResponse
  ): zio.aws.grafana.model.DeleteWorkspaceResponse.ReadOnly = new Wrapper(impl)
}
