package zio.aws.grafana.model
import scala.jdk.CollectionConverters.*
sealed trait NotificationDestinationType {
  def unwrap: software.amazon.awssdk.services.grafana.model.NotificationDestinationType
}
object NotificationDestinationType {
  def wrap(
      value: software.amazon.awssdk.services.grafana.model.NotificationDestinationType
  ): zio.aws.grafana.model.NotificationDestinationType = value match {
    case software.amazon.awssdk.services.grafana.model.NotificationDestinationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.grafana.model.NotificationDestinationType.SNS =>
      val r = SNS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.grafana.model.NotificationDestinationType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.NotificationDestinationType =
      software.amazon.awssdk.services.grafana.model.NotificationDestinationType.UNKNOWN_TO_SDK_VERSION
  }
  case object SNS extends zio.aws.grafana.model.NotificationDestinationType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.NotificationDestinationType =
      software.amazon.awssdk.services.grafana.model.NotificationDestinationType.SNS
  }
}
