package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.grafana.model.primitives.{
  Timestamp,
  TagValue,
  WorkspaceName,
  WorkspaceId,
  Description,
  Endpoint,
  GrafanaVersion,
  TagKey
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class WorkspaceSummary(
    authentication: zio.aws.grafana.model.AuthenticationSummary,
    created: Timestamp,
    description: Option[Description] = None,
    endpoint: Endpoint,
    grafanaVersion: GrafanaVersion,
    id: WorkspaceId,
    modified: Timestamp,
    name: Option[WorkspaceName] = None,
    notificationDestinations: Option[
      Iterable[zio.aws.grafana.model.NotificationDestinationType]
    ] = None,
    status: zio.aws.grafana.model.WorkspaceStatus,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.WorkspaceSummary = {
    import WorkspaceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.WorkspaceSummary
      .builder()
      .authentication(authentication.buildAwsValue())
      .created(Timestamp.unwrap(created): Instant)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .endpoint(Endpoint.unwrap(endpoint): java.lang.String)
      .grafanaVersion(GrafanaVersion.unwrap(grafanaVersion): java.lang.String)
      .id(WorkspaceId.unwrap(id): java.lang.String)
      .modified(Timestamp.unwrap(modified): Instant)
      .optionallyWith(
        name.map(value => WorkspaceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        notificationDestinations.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.notificationDestinationsWithStrings)
      .status(status.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.WorkspaceSummary.ReadOnly =
    zio.aws.grafana.model.WorkspaceSummary.wrap(buildAwsValue())
}
object WorkspaceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.WorkspaceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.WorkspaceSummary =
      zio.aws.grafana.model.WorkspaceSummary(
        authentication.asEditable,
        created,
        description.map(value => value),
        endpoint,
        grafanaVersion,
        id,
        modified,
        name.map(value => value),
        notificationDestinations.map(value => value),
        status,
        tags.map(value => value)
      )
    def authentication: zio.aws.grafana.model.AuthenticationSummary.ReadOnly
    def created: Timestamp
    def description: Option[Description]
    def endpoint: Endpoint
    def grafanaVersion: GrafanaVersion
    def id: WorkspaceId
    def modified: Timestamp
    def name: Option[WorkspaceName]
    def notificationDestinations
        : Option[List[zio.aws.grafana.model.NotificationDestinationType]]
    def status: zio.aws.grafana.model.WorkspaceStatus
    def tags: Option[Map[TagKey, TagValue]]
    def getAuthentication: ZIO[
      Any,
      Nothing,
      zio.aws.grafana.model.AuthenticationSummary.ReadOnly
    ] = ZIO.succeed(authentication)
    def getCreated: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(created)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEndpoint: ZIO[Any, Nothing, Endpoint] = ZIO.succeed(endpoint)
    def getGrafanaVersion: ZIO[Any, Nothing, GrafanaVersion] =
      ZIO.succeed(grafanaVersion)
    def getId: ZIO[Any, Nothing, WorkspaceId] = ZIO.succeed(id)
    def getModified: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(modified)
    def getName: ZIO[Any, AwsError, WorkspaceName] =
      AwsError.unwrapOptionField("name", name)
    def getNotificationDestinations: ZIO[Any, AwsError, List[
      zio.aws.grafana.model.NotificationDestinationType
    ]] = AwsError.unwrapOptionField(
      "notificationDestinations",
      notificationDestinations
    )
    def getStatus: ZIO[Any, Nothing, zio.aws.grafana.model.WorkspaceStatus] =
      ZIO.succeed(status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.WorkspaceSummary
  ) extends zio.aws.grafana.model.WorkspaceSummary.ReadOnly {
    override val authentication
        : zio.aws.grafana.model.AuthenticationSummary.ReadOnly =
      zio.aws.grafana.model.AuthenticationSummary.wrap(impl.authentication())
    override val created: Timestamp =
      zio.aws.grafana.model.primitives.Timestamp(impl.created())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.grafana.model.primitives.Description(value))
    override val endpoint: Endpoint =
      zio.aws.grafana.model.primitives.Endpoint(impl.endpoint())
    override val grafanaVersion: GrafanaVersion =
      zio.aws.grafana.model.primitives.GrafanaVersion(impl.grafanaVersion())
    override val id: WorkspaceId =
      zio.aws.grafana.model.primitives.WorkspaceId(impl.id())
    override val modified: Timestamp =
      zio.aws.grafana.model.primitives.Timestamp(impl.modified())
    override val name: Option[WorkspaceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.grafana.model.primitives.WorkspaceName(value))
    override val notificationDestinations
        : Option[List[zio.aws.grafana.model.NotificationDestinationType]] =
      scala
        .Option(impl.notificationDestinations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.grafana.model.NotificationDestinationType.wrap(item)
          }.toList
        )
    override val status: zio.aws.grafana.model.WorkspaceStatus =
      zio.aws.grafana.model.WorkspaceStatus.wrap(impl.status())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.grafana.model.primitives
              .TagKey(key) -> zio.aws.grafana.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.WorkspaceSummary
  ): zio.aws.grafana.model.WorkspaceSummary.ReadOnly = new Wrapper(impl)
}
