package zio.aws.grafana.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateWorkspaceResponse(
    workspace: zio.aws.grafana.model.WorkspaceDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.CreateWorkspaceResponse = {
    import CreateWorkspaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.CreateWorkspaceResponse
      .builder()
      .workspace(workspace.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.grafana.model.CreateWorkspaceResponse.ReadOnly =
    zio.aws.grafana.model.CreateWorkspaceResponse.wrap(buildAwsValue())
}
object CreateWorkspaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.CreateWorkspaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.grafana.model.CreateWorkspaceResponse =
      zio.aws.grafana.model.CreateWorkspaceResponse(workspace.asEditable)
    def workspace: zio.aws.grafana.model.WorkspaceDescription.ReadOnly
    def getWorkspace: ZIO[
      Any,
      Nothing,
      zio.aws.grafana.model.WorkspaceDescription.ReadOnly
    ] = ZIO.succeed(workspace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.CreateWorkspaceResponse
  ) extends zio.aws.grafana.model.CreateWorkspaceResponse.ReadOnly {
    override val workspace
        : zio.aws.grafana.model.WorkspaceDescription.ReadOnly =
      zio.aws.grafana.model.WorkspaceDescription.wrap(impl.workspace())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.CreateWorkspaceResponse
  ): zio.aws.grafana.model.CreateWorkspaceResponse.ReadOnly = new Wrapper(impl)
}
